/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.Arrays;

public class IntArray {
    private static final int INITIAL_CAPACITY = 10;
    private static final int[] EMPTY_ARRAY = new int[0];
    private int[] buffer = EMPTY_ARRAY;
    private int size;

    public IntArray() {
    }

    public IntArray(int initialCapacity) {
        this.buffer = new int[initialCapacity];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(int value) {
        this.grow(this.size + 1);
        this.buffer[this.size++] = value;
    }

    public void add(int index, int value) {
        this.checkBounds(index);
        this.grow(this.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[index] = value;
        ++this.size;
    }

    public void addAll(IntArray other) {
        this.grow(this.size + other.size());
        System.arraycopy(other.buffer, 0, this.buffer, this.size, other.size);
        this.size += other.size;
    }

    public void addAll(int[] array) {
        this.grow(this.size + array.length);
        System.arraycopy(array, 0, this.buffer, this.size, array.length);
        this.size += array.length;
    }

    public int remove(int index) {
        this.checkBounds(index);
        int old = this.buffer[index];
        int n = this.size - index - 1;
        if (n > 0) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, n);
        }
        return old;
    }

    public void remove(int from, int to) {
        this.checkBounds(from);
        this.checkBounds(to);
        System.arraycopy(this.buffer, to, this.buffer, from, this.size - to);
    }

    public void clear() {
        this.size = 0;
    }

    public int get(int index) {
        this.checkRange(index);
        return this.buffer[index];
    }

    public int set(int index, int value) {
        this.checkBounds(index);
        int old = this.buffer[index];
        this.buffer[index] = value;
        return old;
    }

    public int[] toArray() {
        return this.size == 0 ? EMPTY_ARRAY : Arrays.copyOf(this.buffer, this.size);
    }

    public void trimToSize() {
        if (this.size == 0) {
            this.buffer = EMPTY_ARRAY;
        } else if (this.size < this.buffer.length) {
            this.buffer = Arrays.copyOf(this.buffer, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        int capacity = this.buffer.length;
        if (minCapacity > capacity) {
            int newCapacity;
            int n = newCapacity = capacity == 0 ? 10 : capacity + (capacity >> 1);
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            try {
                this.buffer = Arrays.copyOf(this.buffer, newCapacity);
            }
            catch (OutOfMemoryError e) {
                this.buffer = Arrays.copyOf(this.buffer, minCapacity);
            }
        }
    }

    private void checkBounds(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + index);
        }
        this.checkRange(index);
    }

    private void checkRange(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", size: " + this.size);
        }
    }
}

