/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CProject;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.cdt.internal.ui.wizards.filewizard.AbstractFileCreationWizardPage;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewSourceFileGenerator;
import org.eclipse.cdt.ui.CodeGeneration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewHeaderFileCreationWizardPage
extends AbstractFileCreationWizardPage {
    private final String KEY_LAST_USED_TEMPLATE = "LastUsedHeaderTemplate";
    private ITranslationUnit fNewFileTU = null;
    private StringDialogField fNewFileDialogField;

    public NewHeaderFileCreationWizardPage() {
        super(NewFileWizardMessages.NewHeaderFileCreationWizard_title);
        this.setTitle(NewFileWizardMessages.NewHeaderFileCreationWizardPage_title);
        this.setDescription(NewFileWizardMessages.NewHeaderFileCreationWizardPage_description);
        this.fNewFileDialogField = new StringDialogField();
        this.fNewFileDialogField.setDialogFieldListener(new IDialogFieldListener(){

            @Override
            public void dialogFieldChanged(DialogField field) {
                NewHeaderFileCreationWizardPage.this.handleFieldChanged(2);
            }
        });
        this.fNewFileDialogField.setLabelText(NewFileWizardMessages.NewHeaderFileCreationWizardPage_headerFile_label);
    }

    @Override
    protected void setFocus() {
        this.fNewFileDialogField.setFocus();
    }

    @Override
    protected void createFileControls(Composite parent, int nColumns) {
        this.fNewFileDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fNewFileDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new AbstractFileCreationWizardPage.StatusFocusListener(2));
    }

    @Override
    public IPath getFileFullPath() {
        IPath folderPath;
        String str = this.fNewFileDialogField.getText();
        Path path = null;
        if (str.length() > 0 && !(path = new Path(str)).isAbsolute() && (folderPath = this.getSourceFolderFullPath()) != null) {
            path = folderPath.append((IPath)path);
        }
        return path;
    }

    @Override
    protected IStatus fileNameChanged() {
        StatusInfo status = new StatusInfo();
        IPath filePath = this.getFileFullPath();
        if (filePath == null) {
            status.setError(NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_EnterFileName);
            return status;
        }
        IPath sourceFolderPath = this.getSourceFolderFullPath();
        if (sourceFolderPath == null || !sourceFolderPath.isPrefixOf(filePath)) {
            status.setError(NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_FileNotInSourceFolder);
            return status;
        }
        IResource file = this.getWorkspaceRoot().findMember(filePath);
        if (file != null && file.exists()) {
            if (file.getType() == 1) {
                status.setError(NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_FileExists);
            } else if (file.getType() == 2) {
                status.setError(NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_MatchingFolderExists);
            } else {
                status.setError(NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_MatchingResourceExists);
            }
            return status;
        }
        IPath folderPath = filePath.removeLastSegments(1).makeRelative();
        IResource folder = this.getWorkspaceRoot().findMember(folderPath);
        if (folder == null || !folder.exists() || folder.getType() != 4 && folder.getType() != 2) {
            status.setError(NLS.bind((String)NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
            return status;
        }
        IStatus convStatus = CConventions.validateHeaderFileName((IProject)this.getCurrentProject(), (String)filePath.lastSegment());
        if (convStatus.getSeverity() == 4) {
            status.setError(NLS.bind((String)NewFileWizardMessages.NewHeaderFileCreationWizardPage_error_InvalidFileName, (Object)convStatus.getMessage()));
            return status;
        }
        if (convStatus.getSeverity() == 2) {
            status.setWarning(NLS.bind((String)NewFileWizardMessages.NewHeaderFileCreationWizardPage_warning_FileNameDiscouraged, (Object)convStatus.getMessage()));
        }
        return status;
    }

    @Override
    public void createFile(IProgressMonitor monitor) throws CoreException {
        IPath filePath = this.getFileFullPath();
        if (filePath != null) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                this.fNewFileTU = null;
                IFile newFile = NewSourceFileGenerator.createHeaderFile(filePath, true, monitor);
                if (newFile != null) {
                    this.fNewFileTU = (ITranslationUnit)CoreModel.getDefault().create(newFile);
                    if (this.fNewFileTU != null) {
                        String lineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)this.fNewFileTU);
                        String content = CodeGeneration.getHeaderFileContent(this.getTemplate(), this.fNewFileTU, lineDelimiter);
                        if (content != null) {
                            this.fNewFileTU.getBuffer().setContents(content.toCharArray());
                            this.fNewFileTU.save(monitor, true);
                        }
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public ITranslationUnit getCreatedFileTU() {
        return this.fNewFileTU;
    }

    @Override
    protected Template[] getApplicableTemplates() {
        return StubUtility.getFileTemplatesForContentTypes(new String[]{"org.eclipse.cdt.core.cxxHeader", "org.eclipse.cdt.core.cHeader"}, null);
    }

    @Override
    public String getDefaultTemplateName() {
        String contentType;
        Template[] templates;
        IProject project;
        String name = this.getDialogSettings().get("LastUsedHeaderTemplate");
        if (name == null && (project = this.getCurrentProject()) != null && (templates = StubUtility.getFileTemplatesForContentTypes(new String[]{contentType = CProject.hasCCNature((IProject)project) ? "org.eclipse.cdt.core.cxxHeader" : "org.eclipse.cdt.core.cHeader"}, null)).length != 0) {
            name = templates[0].getName();
        }
        return name;
    }

    @Override
    public void saveLastUsedTemplateName(String name) {
        this.getDialogSettings().put("LastUsedHeaderTemplate", name);
    }
}

