/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.data.xcdl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;
import org.eclipse.embedcdt.packs.core.tree.PackNode;
import org.eclipse.embedcdt.packs.core.xml.DocumentParseException;
import org.eclipse.embedcdt.packs.core.xml.GenericParser;

public class ContentParser
extends GenericParser {
    Set<String> fLeafNodes;
    Set<String> fPackNodes = new HashSet<String>();
    String[] fGroupsToIgnore;
    Map<String, String> fReplaceMap;

    public ContentParser() {
        this.fPackNodes.add("package");
        this.fPackNodes.add("version");
        this.fLeafNodes = new HashSet<String>();
        this.fLeafNodes.add("devicefamily");
        this.fLeafNodes.add("board");
        this.fLeafNodes.add("component");
        this.fLeafNodes.add("bundle");
        this.fLeafNodes.add("example");
        this.fLeafNodes.add("keyword");
        this.fGroupsToIgnore = new String[]{"packages", "versions"};
        this.fReplaceMap = new HashMap<String, String>();
        this.fReplaceMap.put("devicefamily", "family");
    }

    @Override
    public String[] getGroupsToIgnore() {
        return this.fGroupsToIgnore;
    }

    @Override
    public Leaf addNewChild(Node parent, String type) {
        Leaf node = this.fPackNodes.contains(type) ? PackNode.addNewChild(parent, type) : (this.fLeafNodes.contains(type) ? Leaf.addNewChild(parent, type) : Node.addNewChild(parent, type));
        return node;
    }

    @Override
    public Map<String, String> getReplacements() {
        return this.fReplaceMap;
    }

    @Override
    public void checkSchemaVersion(String schemaVersion) throws DocumentParseException {
        if (!"1.1".equals(schemaVersion)) {
            throw new DocumentParseException("Unrecognised schema version " + schemaVersion + ", refresh");
        }
    }
}

