/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageBookmarkElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageExperimentElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFileElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageSupplFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ManifestReader {
    private static final String SCHEMA_FOLDER_NAME = "schema";
    private static final String EXPORT_MANIFEST_SCHEMA_FILE_NAME = "export-manifest.xsd";
    private static final @NonNull TracePackageElement @NonNull [] EMPTY_ARRAY = new TracePackageElement[0];

    private ManifestReader() {
    }

    public static void validateManifest(InputStream input) throws IOException {
        URL schemaFileUrl = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(SCHEMA_FOLDER_NAME).append(EXPORT_MANIFEST_SCHEMA_FILE_NAME), null);
        if (schemaFileUrl == null) {
            throw new IOException(MessageFormat.format(Messages.TracePackageExtractManifestOperation_SchemaFileNotFound, EXPORT_MANIFEST_SCHEMA_FILE_NAME));
        }
        try {
            Schema schema = XmlUtils.newSafeSchemaFactory().newSchema(new StreamSource(schemaFileUrl.openStream()));
            XmlUtils.safeValidate((Schema)schema, (Source)new StreamSource(input));
        }
        catch (IOException | SAXException e) {
            throw new IOException(Messages.TracePackageExtractManifestOperation_ErrorManifestNotValid, e);
        }
    }

    public static TracePackageElement[] loadElementsFromManifest(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        Document doc = XmlUtils.newSafeDocumentBuilderFactory().newDocumentBuilder().parse(inputStream);
        Element rootElement = doc.getDocumentElement();
        return ManifestReader.loadElementsFromNode(rootElement);
    }

    public static TracePackageElement[] loadElementsFromNode(Element rootElement) {
        ArrayList<TracePackageElement> packageElements = new ArrayList<TracePackageElement>();
        NodeList experimentElements = rootElement.getElementsByTagName("experiment");
        ManifestReader.loadTracesFomNodeList(packageElements, experimentElements);
        NodeList traceElements = rootElement.getElementsByTagName("trace");
        ManifestReader.loadTracesFomNodeList(packageElements, traceElements);
        return packageElements.toArray(EMPTY_ARRAY);
    }

    private static void loadTracesFomNodeList(List<TracePackageElement> packageElements, NodeList traceElements) {
        int i = 0;
        while (i < traceElements.getLength()) {
            Node traceNode = traceElements.item(i);
            if (traceNode.getNodeType() == 1) {
                TracePackageTraceElement element;
                Element traceElement = (Element)traceNode;
                String traceName = traceElement.getAttribute("name");
                String traceType = traceElement.getAttribute("type");
                if (traceNode.getNodeName().equals("experiment")) {
                    element = new TracePackageExperimentElement(null, traceName, traceType);
                    new TracePackageFilesElement((TracePackageElement)element, "");
                    NodeList expTraces = traceElement.getElementsByTagName("exp-trace");
                    j = 0;
                    while (j < expTraces.getLength()) {
                        Node expTraceNode = expTraces.item(j);
                        if (expTraceNode.getNodeType() == 1) {
                            Element expTraceElement = (Element)expTraceNode;
                            String expTrace = expTraceElement.getAttribute("name");
                            ((TracePackageExperimentElement)element).addExpTrace(expTrace);
                        }
                        ++j;
                    }
                } else {
                    element = new TracePackageTraceElement(null, traceName, traceType);
                    NodeList fileElements = traceElement.getElementsByTagName("file");
                    j = 0;
                    while (j < fileElements.getLength()) {
                        Node fileNode = fileElements.item(j);
                        if (fileNode.getNodeType() == 1) {
                            Element fileElement = (Element)fileNode;
                            String fileName = fileElement.getAttribute("name");
                            new TracePackageFilesElement((TracePackageElement)element, fileName);
                        }
                        ++j;
                    }
                }
                NodeList suppFilesElements = traceElement.getElementsByTagName("supplementary-file");
                if (suppFilesElements.getLength() > 0) {
                    TracePackageSupplFilesElement supplFilesElement = new TracePackageSupplFilesElement(element);
                    int j = 0;
                    while (j < suppFilesElements.getLength()) {
                        Node suppFileNode = suppFilesElements.item(j);
                        if (suppFileNode.getNodeType() == 1) {
                            Element suppFileElement = (Element)suppFileNode;
                            String fileName = suppFileElement.getAttribute("name");
                            new TracePackageSupplFileElement(fileName, supplFilesElement);
                        }
                        ++j;
                    }
                }
                ArrayList<Map<String, String>> bookmarkAttribs = new ArrayList<Map<String, String>>();
                NodeList bookmarksElements = traceElement.getElementsByTagName("bookmarks");
                int j = 0;
                while (j < bookmarksElements.getLength()) {
                    Node bookmarksNode = bookmarksElements.item(j);
                    if (bookmarksNode.getNodeType() == 1) {
                        NodeList bookmarkElements = traceElement.getElementsByTagName("bookmark");
                        int k = 0;
                        while (k < bookmarkElements.getLength()) {
                            Node bookmarkNode = bookmarkElements.item(k);
                            if (bookmarkNode.getNodeType() == 1) {
                                Element bookmarkElement = (Element)bookmarkNode;
                                NamedNodeMap attributesMap = bookmarkElement.getAttributes();
                                HashMap<String, String> attribs = new HashMap<String, String>();
                                int l = 0;
                                while (l < attributesMap.getLength()) {
                                    Node item = attributesMap.item(l);
                                    attribs.put(item.getNodeName(), item.getNodeValue());
                                    ++l;
                                }
                                bookmarkAttribs.add(attribs);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                if (!bookmarkAttribs.isEmpty()) {
                    new TracePackageBookmarkElement(element, bookmarkAttribs);
                }
                packageElements.add(element);
            }
            ++i;
        }
    }
}

