/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.symbols;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.core.symbols.IMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;

public class BasicSymbolProvider
implements ISymbolProvider {
    private final @NonNull ITmfTrace fTrace;
    private final @NonNull List<@NonNull IMappingFile> fMappingFiles = new ArrayList<IMappingFile>();

    public BasicSymbolProvider(@NonNull ITmfTrace trace) {
        this.fTrace = trace;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public synchronized @NonNull List<@NonNull IMappingFile> getMappingFiles() {
        return ImmutableList.copyOf(this.fMappingFiles);
    }

    public synchronized void setMappingFiles(@NonNull List<@NonNull IMappingFile> mappingFiles) {
        this.fMappingFiles.clear();
        this.fMappingFiles.addAll(mappingFiles);
    }

    public void loadConfiguration(IProgressMonitor monitor) {
    }

    public @Nullable TmfResolvedSymbol getSymbol(long address) {
        return BasicSymbolProvider.getSymbol(address, this.fMappingFiles);
    }

    public @Nullable TmfResolvedSymbol getSymbol(int pid, long timestamp, long address) {
        TmfResolvedSymbol symbol = BasicSymbolProvider.getSymbol(address, this.fMappingFiles.stream().filter(mf -> mf.getPid() == pid).collect(Collectors.toList()));
        if (symbol != null) {
            return symbol;
        }
        return BasicSymbolProvider.getSymbol(address, this.fMappingFiles.stream().filter(mf -> mf.getPid() < 0).collect(Collectors.toList()));
    }

    private static @Nullable TmfResolvedSymbol getSymbol(long address, List<IMappingFile> mappingFiles) {
        TmfResolvedSymbol currentFloorEntry = null;
        for (IMappingFile mf : mappingFiles) {
            TmfResolvedSymbol floorEntry = mf.getSymbolEntry(address);
            if (floorEntry == null) continue;
            long floorValue = floorEntry.getBaseAddress();
            if (floorValue == address) {
                return floorEntry;
            }
            if (currentFloorEntry == null) {
                currentFloorEntry = floorEntry;
                continue;
            }
            if (address - floorValue >= address - currentFloorEntry.getBaseAddress()) continue;
            currentFloorEntry = floorEntry;
        }
        if (currentFloorEntry == null) {
            return null;
        }
        return currentFloorEntry;
    }

    @Override
    public ISymbolProviderPreferencePage createPreferencePage() {
        return new BasicSymbolProviderPreferencePage(this);
    }
}

