/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.CreateElementInTUOperation;
import org.eclipse.cdt.internal.core.model.CreateSourceReferenceOperation;
import org.eclipse.cdt.internal.core.model.DeleteElementsOperation;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.cdt.internal.core.model.Util;

public class CopyElementsOperation
extends MultiOperation {
    public CopyElementsOperation(ICElement[] elementsToCopy, ICElement[] destContainers, boolean force) {
        super(elementsToCopy, destContainers, force);
    }

    public CopyElementsOperation(ICElement[] elementsToCopy, ICElement destContainer, boolean force) {
        this(elementsToCopy, new ICElement[]{destContainer}, force);
    }

    @Override
    protected String getMainTaskName() {
        return CoreModelMessages.getString("operation.copyElementProgress");
    }

    protected CModelOperation getNestedOperation(ICElement element) {
        ICElement parentElement = this.getDestinationParent(element);
        String name = element.getElementName();
        int type = element.getElementType();
        return new CreateSourceReferenceOperation(parentElement, name, type, this.getSourceFor(element));
    }

    protected ITranslationUnit getDestinationTranslationUnit(ICElement element) {
        ICElement dest = this.getDestinationParent(element);
        return (ITranslationUnit)dest.getAncestor(60);
    }

    protected ITranslationUnit getSourceTranslationUnit(ICElement element) {
        return (ITranslationUnit)element.getAncestor(60);
    }

    private String getSourceFor(ICElement element) {
        if (element instanceof ISourceReference) {
            try {
                ISourceReference source = (ISourceReference)((Object)element);
                ISourceRange range = source.getSourceRange();
                Object contents = source.getSource();
                StringBuilder sb = new StringBuilder((String)contents);
                IBuffer buffer = this.getSourceTranslationUnit(element).getBuffer();
                boolean newLineFound = false;
                int offset = range.getStartPos() + range.getLength();
                while (true) {
                    try {
                        char c = buffer.getChar(offset);
                        if (c == ';') {
                            sb.append(c);
                        } else if (c == '\r' || c == '\n') {
                            newLineFound = true;
                            sb.append(c);
                        } else {
                            if (newLineFound || c != ' ') break;
                            sb.append(c);
                        }
                    }
                    catch (Exception e) {
                        break;
                    }
                    ++offset;
                }
                if (!((String)(contents = sb.toString())).endsWith(Util.LINE_SEPARATOR)) {
                    contents = (String)contents + Util.LINE_SEPARATOR;
                }
                return contents;
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    protected void processElement(ICElement element) throws CModelException {
        CModelOperation op = this.getNestedOperation(element);
        if (op == null) {
            return;
        }
        boolean isInTUOperation = op instanceof CreateElementInTUOperation;
        if (isInTUOperation && this.isMove()) {
            DeleteElementsOperation deleteOp = new DeleteElementsOperation(new ICElement[]{element}, this.fForce);
            this.executeNestedOperation(deleteOp, 1);
        }
        if (isInTUOperation) {
            ICElement anchor;
            CreateElementInTUOperation inTUop = (CreateElementInTUOperation)op;
            ICElement sibling = (ICElement)this.fInsertBeforeElements.get(element);
            if (sibling != null) {
                inTUop.setRelativePosition(sibling, 3);
            } else if (this.isRename() && (anchor = this.resolveRenameAnchor(element)) != null) {
                inTUop.setRelativePosition(anchor, 2);
            }
            String newName = this.getNewNameFor(element);
            if (newName != null) {
                inTUop.setAlteredName(newName);
            }
        }
        this.executeNestedOperation(op, 1);
        ITranslationUnit destUnit = this.getDestinationTranslationUnit(element);
        if (!destUnit.isWorkingCopy()) {
            destUnit.close();
        }
    }

    private ICElement resolveRenameAnchor(ICElement element) throws CModelException {
        ICElement[] children;
        IParent parent = (IParent)((Object)element.getParent());
        ICElement[] iCElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICElement child = iCElementArray[n2];
            if (child.equals(element)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected ICModelStatus verify() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new CModelStatus(980);
        }
        return CModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(ICElement element) throws CModelException {
        if (element == null || !element.exists()) {
            this.error(969, element);
        } else {
            if (element.getElementType() < 60) {
                this.error(967, element);
            }
            if (element.isReadOnly()) {
                this.error(976, element);
            }
            ICElement dest = this.getDestinationParent(element);
            this.verifyDestination(element, dest);
            this.verifySibling(element, dest);
            if (this.fRenamingsList != null) {
                this.verifyRenaming(element);
            }
        }
    }
}

