/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.commands;

import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public final class ResourcePathConverter
extends AbstractParameterValueConverter {
    public final Object convertToObject(String parameterValue) throws ParameterValueConversionException {
        IPath path = IPath.fromOSString((String)parameterValue);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember(path);
        if (resource == null || !resource.exists()) {
            throw new ParameterValueConversionException("parameterValue must be the path of an existing resource");
        }
        return resource;
    }

    public final String convertToString(Object parameterValue) throws ParameterValueConversionException {
        if (!(parameterValue instanceof IResource)) {
            throw new ParameterValueConversionException("parameterValue must be an IResource");
        }
        IResource resource = (IResource)parameterValue;
        return resource.getFullPath().toString();
    }
}

