/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public abstract class AbstractMavenDialog
extends SelectionStatusDialog {
    protected static final String KEY_WIDTH = "width";
    protected static final String KEY_HEIGHT = "height";
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    protected final IDialogSettings settings;
    private Point location;
    private Point size;

    protected AbstractMavenDialog(Shell parent, String settingsSection) {
        super(parent);
        this.settings = AbstractMavenDialog.getDialogSettings(settingsSection);
    }

    private static IDialogSettings getDialogSettings(String settingsSection) {
        IDialogSettings settings;
        M2EUIPluginActivator activator = M2EUIPluginActivator.getDefault();
        IDialogSettings pluginSettings = activator != null ? activator.getDialogSettings() : null;
        IDialogSettings iDialogSettings = settings = pluginSettings != null ? pluginSettings.getSection(settingsSection) : null;
        if (settings == null) {
            settings = new DialogSettings(settingsSection);
            settings.put(KEY_WIDTH, 480);
            settings.put(KEY_HEIGHT, 450);
            if (pluginSettings != null) {
                pluginSettings.addSection(settings);
            }
        }
        return settings;
    }

    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        if (this.size != null) {
            result.x = Math.max(result.x, this.size.x);
            result.y = Math.max(result.y, this.size.y);
            Rectangle display = this.getShell().getDisplay().getClientArea();
            result.x = Math.min(result.x, display.width);
            result.y = Math.min(result.y, display.height);
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point result = super.getInitialLocation(initialSize);
        if (this.location != null) {
            int ye;
            result.x = this.location.x;
            result.y = this.location.y;
            Rectangle display = this.getShell().getDisplay().getClientArea();
            int xe = result.x + initialSize.x;
            if (xe > display.width) {
                result.x -= xe - display.width;
            }
            if ((ye = result.y + initialSize.y) > display.height) {
                result.y -= ye - display.height;
            }
        }
        return result;
    }

    public boolean close() {
        this.writeSettings();
        return super.close();
    }

    protected void readSettings() {
        try {
            int x = this.settings.getInt(KEY_X);
            int y = this.settings.getInt(KEY_Y);
            this.location = new Point(x, y);
        }
        catch (NumberFormatException e) {
            this.location = null;
        }
        try {
            int width = this.settings.getInt(KEY_WIDTH);
            int height = this.settings.getInt(KEY_HEIGHT);
            this.size = new Point(width, height);
        }
        catch (NumberFormatException e) {
            this.size = null;
        }
    }

    private void writeSettings() {
        Point location = this.getShell().getLocation();
        this.settings.put(KEY_X, location.x);
        this.settings.put(KEY_Y, location.y);
        Point size = this.getShell().getSize();
        this.settings.put(KEY_WIDTH, size.x);
        this.settings.put(KEY_HEIGHT, size.y);
    }
}

