/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.StandardComparisonFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class StandardComparisonCleanUpCore
extends AbstractCleanUp {
    public StandardComparisonCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public StandardComparisonCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.standard_comparison");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null || !this.isEnabled("cleanup.standard_comparison")) {
            return null;
        }
        return StandardComparisonFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.standard_comparison")) {
            result.add(MultiFixMessages.StandardComparisonCleanUp_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.standard_comparison")) {
            return "boolean isSmaller = text.compareTo(\"smaller\") < 0;\n";
        }
        return "boolean isSmaller = text.compareTo(\"smaller\") == -1;\n";
    }
}

