/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class AddToIndexCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedNodes = this.getSelectedNodes(event);
        if (selectedNodes.isEmpty() || ((RepositoryTreeNode)selectedNodes.get(0)).getRepository() == null) {
            return null;
        }
        Repository repository = ((RepositoryTreeNode)selectedNodes.get(0)).getRepository();
        Path workTreePath = new Path(repository.getWorkTree().getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Git git = new Git(repository);){
                AddCommand addCommand = git.add();
                Collection<IPath> paths = this.getSelectedFileAndFolderPaths(event);
                for (IPath path : paths) {
                    String repoRelativepath = path.equals((Object)workTreePath) ? "." : path.removeFirstSegments(path.matchingFirstSegments((IPath)workTreePath)).setDevice(null).toString();
                    addCommand.addFilepattern(repoRelativepath);
                }
                addCommand.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            Activator.logError(UIText.AddToIndexCommand_addingFilesFailed, e);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.isWorkingDirSelection();
    }
}

