/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator.typeparam;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.builder.JavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.generator.AbstractJavaElementGenerator;
import org.eclipse.scout.sdk.core.java.generator.typeparam.ITypeParameterGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.util.Strings;

public class TypeParameterGenerator<TYPE extends ITypeParameterGenerator<TYPE>>
extends AbstractJavaElementGenerator<TYPE>
implements ITypeParameterGenerator<TYPE> {
    private final List<JavaBuilderContextFunction<String>> m_bounds;

    protected TypeParameterGenerator() {
        this.m_bounds = new ArrayList<JavaBuilderContextFunction<String>>();
    }

    protected TypeParameterGenerator(ITypeParameter param) {
        super(param);
        this.m_bounds = param.bounds().map(IType::reference).map(JavaBuilderContextFunction::create).collect(Collectors.toList());
    }

    public static ITypeParameterGenerator<?> create() {
        return new TypeParameterGenerator();
    }

    public static ITypeParameterGenerator<?> create(ITypeParameter param) {
        return new TypeParameterGenerator(param);
    }

    @Override
    public TYPE withBinding(String binding) {
        if (Strings.hasText((CharSequence)binding)) {
            this.m_bounds.add(JavaBuilderContextFunction.create(binding));
        }
        return (TYPE)((ITypeParameterGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withBindingFrom(Class<A> apiDefinition, Function<A, String> bindingSupplier) {
        if (bindingSupplier != null) {
            this.m_bounds.add(new ApiFunction<A, String>(apiDefinition, bindingSupplier));
        }
        return (TYPE)((ITypeParameterGenerator)this.thisInstance());
    }

    @Override
    public TYPE withBindingFunc(Function<IJavaBuilderContext, String> bindingSupplier) {
        if (bindingSupplier != null) {
            this.m_bounds.add(JavaBuilderContextFunction.create(bindingSupplier));
        }
        return (TYPE)((ITypeParameterGenerator)this.thisInstance());
    }

    @Override
    public Stream<String> bounds() {
        return this.boundsFunc().map(JavaBuilderContextFunction::apply).flatMap(Optional::stream);
    }

    @Override
    public Stream<JavaBuilderContextFunction<String>> boundsFunc() {
        return this.m_bounds.stream();
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        builder.append(TypeParameterGenerator.ensureValidJavaName(this.elementName(builder.context()).orElse(Character.toString('?'))));
        Stream<ISourceGenerator> bounds = this.m_bounds.stream().map(binding -> b -> b.refFunc((Function<IJavaBuilderContext, ? extends CharSequence>)binding)).map(g -> g.generalize(JavaSourceBuilder::create));
        builder.append(bounds, " extends ", " & ", null);
    }
}

