/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.PatternInstanceofToSwitchFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class PatternInstanceofToSwitchCleanUpCore
extends AbstractCleanUp {
    public PatternInstanceofToSwitchCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public PatternInstanceofToSwitchCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.switch_for_instanceof_pattern");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean convertIfElseInstanceOfChainToSwitch = this.isEnabled("cleanup.switch_for_instanceof_pattern");
        if (!convertIfElseInstanceOfChainToSwitch) {
            return null;
        }
        return PatternInstanceofToSwitchFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.switch_for_instanceof_pattern")) {
            result.add(MultiFixMessages.CodeStyleCleanUp_PatternInstanceOfToSwitch_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.switch_for_instanceof_pattern")) {
            return "switch (x) {\ncase Integer xInt -> i = xInt.intValue();\ncase Double xDouble -> d = xDouble.doubleValue():\ncase Boolean xBoolean -> b = xBoolean.booleanValue();\ncase null, default -> {\n  i = 0;\n  d = 0.0D;\n  b = false;\n}\n}\n\n";
        }
        return "if (x instanceof Integer xInt) {\n    i = xInt.intValue();\n} else if (x instanceof Double xDouble) {\n    d = xDouble.doubleValue();\n} else if (x instancoef Boolean) {\n    b = xBoolean.booleanValue();\n} else {\n    i = 0;\n    d = 0.0D;\n    b = false;\n}\n";
    }
}

