/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.github.core.service;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.GitHubService;

public class MilestoneService
extends GitHubService {
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String DUE_ON = "due_on";
    private static final String STATE = "state";

    public MilestoneService() {
    }

    public MilestoneService(GitHubClient client) {
        super(client);
    }

    public List<Milestone> getMilestones(IRepositoryIdProvider repository, String state) throws IOException {
        String repoId = this.getId(repository);
        return this.getMilestones(repoId, state);
    }

    public List<Milestone> getMilestones(String user, String repository, String state) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = String.valueOf(user) + '/' + repository;
        return this.getMilestones(repoId, state);
    }

    private List<Milestone> getMilestones(String id, String state) throws IOException {
        String uri = "/repos/" + id + "/milestones";
        PagedRequest request = this.createPagedRequest();
        if (state != null) {
            request.setParams(Collections.singletonMap(STATE, state));
        }
        request.setUri(uri).setType(new TypeToken<List<Milestone>>(){}.getType());
        return this.getAll(request);
    }

    public Milestone createMilestone(IRepositoryIdProvider repository, Milestone milestone) throws IOException {
        String repoId = this.getId(repository);
        return this.createMilestone(repoId, milestone);
    }

    public Milestone createMilestone(String user, String repository, Milestone milestone) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = String.valueOf(user) + '/' + repository;
        return this.createMilestone(repoId, milestone);
    }

    private Map<String, Object> createParams(Milestone milestone, boolean titleRequired) {
        Date date;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String value = milestone.getTitle();
        if (titleRequired && value == null) {
            throw new IllegalArgumentException("Milestone title must not be null");
        }
        if (value != null) {
            params.put(TITLE, value);
        }
        if ((value = milestone.getState()) != null) {
            if (!"open".equals(value) && !"closed".equals(value)) {
                throw new IllegalArgumentException("Milestone state must be 'open' or 'closed', or null for default ('open')");
            }
            params.put(STATE, value);
        }
        if ((value = milestone.getDescription()) != null) {
            params.put(DESCRIPTION, value);
        }
        if ((date = milestone.getDueOn()) != null) {
            params.put(DUE_ON, date);
        }
        if (params.isEmpty()) {
            throw new IllegalArgumentException("Milestone operation requires at least one of title, description, state, or due date");
        }
        return params;
    }

    private Milestone createMilestone(String id, Milestone milestone) throws IOException {
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        String uri = "/repos/" + id + "/milestones";
        Map<String, Object> dto = this.createParams(milestone, true);
        return (Milestone)this.client.post(uri, dto, (Type)((Object)Milestone.class));
    }

    public Milestone getMilestone(IRepositoryIdProvider repository, int number) throws IOException {
        return this.getMilestone(repository, Integer.toString(number));
    }

    public Milestone getMilestone(IRepositoryIdProvider repository, String number) throws IOException {
        String repoId = this.getId(repository);
        return this.getMilestone(repoId, number);
    }

    public Milestone getMilestone(String user, String repository, int number) throws IOException {
        return this.getMilestone(user, repository, Integer.toString(number));
    }

    public Milestone getMilestone(String user, String repository, String number) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = String.valueOf(user) + '/' + repository;
        return this.getMilestone(repoId, number);
    }

    private Milestone getMilestone(String id, String number) throws IOException {
        if (number == null || number.isEmpty()) {
            throw new IllegalArgumentException("Milestone cannot be null or empty");
        }
        String uri = "/repos/" + id + "/milestones" + '/' + number;
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType((Type)((Object)Milestone.class));
        return (Milestone)this.client.get(request).getBody();
    }

    public void deleteMilestone(IRepositoryIdProvider repository, int milestone) throws IOException {
        this.deleteMilestone(repository, Integer.toString(milestone));
    }

    public void deleteMilestone(IRepositoryIdProvider repository, String milestone) throws IOException {
        String repoId = this.getId(repository);
        this.deleteMilestone(repoId, milestone);
    }

    public void deleteMilestone(String user, String repository, int milestone) throws IOException {
        this.deleteMilestone(user, repository, Integer.toString(milestone));
    }

    public void deleteMilestone(String user, String repository, String milestone) throws IOException {
        this.verifyRepository(user, repository);
        String repoId = String.valueOf(user) + '/' + repository;
        this.deleteMilestone(repoId, milestone);
    }

    private void deleteMilestone(String id, String milestone) throws IOException {
        if (milestone == null || milestone.isEmpty()) {
            throw new IllegalArgumentException("Milestone cannot be null or empty");
        }
        String uri = "/repos/" + id + "/milestones" + '/' + milestone;
        this.client.delete(uri);
    }

    public Milestone editMilestone(IRepositoryIdProvider repository, Milestone milestone) throws IOException {
        String repoId = this.getId(repository);
        if (milestone == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        String uri = "/repos/" + repoId + "/milestones" + '/' + milestone.getNumber();
        Map<String, Object> dto = this.createParams(milestone, false);
        return (Milestone)this.client.post(uri, dto, (Type)((Object)Milestone.class));
    }
}

