/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.DeltaProcessor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;

public class DeletePackageFragmentRootOperation
extends JavaModelOperation {
    int updateResourceFlags;
    int updateModelFlags;

    public DeletePackageFragmentRootOperation(IPackageFragmentRoot root, int updateResourceFlags, int updateModelFlags) {
        super(root);
        this.updateResourceFlags = updateResourceFlags;
        this.updateModelFlags = updateModelFlags;
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        IIncludePathEntry rootEntry = root.getRawIncludepathEntry();
        DeltaProcessor deltaProcessor = JavaModelManager.getJavaModelManager().getDeltaProcessor();
        if (deltaProcessor.oldRoots == null) {
            deltaProcessor.oldRoots = new HashMap();
        }
        if ((this.updateModelFlags & 2) != 0) {
            this.updateProjectClasspath(rootEntry.getPath(), root.getJavaScriptProject(), deltaProcessor.oldRoots);
        }
        if ((this.updateModelFlags & 4) != 0) {
            this.updateReferringProjectClasspaths(rootEntry.getPath(), root.getJavaScriptProject(), deltaProcessor.oldRoots);
        }
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.deleteResource(root, rootEntry);
        }
    }

    protected void deleteResource(IPackageFragmentRoot root, IIncludePathEntry rootEntry) throws JavaScriptModelException {
        char[][] exclusionPatterns = ((ClasspathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (rootEntry.getEntryKind() != 3 || exclusionPatterns == null) {
            try {
                rootResource.delete(this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException e) {
                throw new JavaScriptModelException(e);
            }
        }
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() == 2) {
                    IPath path = proxy.requestFullPath();
                    if (DeletePackageFragmentRootOperation.this.prefixesOneOf(path, nestedFolders)) {
                        return !DeletePackageFragmentRootOperation.this.equalsOneOf(path, nestedFolders);
                    }
                    proxy.requestResource().delete(DeletePackageFragmentRootOperation.this.updateResourceFlags, DeletePackageFragmentRootOperation.this.progressMonitor);
                    return false;
                }
                proxy.requestResource().delete(DeletePackageFragmentRootOperation.this.updateResourceFlags, DeletePackageFragmentRootOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new JavaScriptModelException(e);
        }
        DeletePackageFragmentRootOperation.setAttribute("hasModifiedResource", "true");
    }

    protected void updateReferringProjectClasspaths(IPath rootPath, IJavaScriptProject projectOfRoot, Map oldRoots) throws JavaScriptModelException {
        IJavaScriptModel model = this.getJavaModel();
        IJavaScriptProject[] projects = model.getJavaScriptProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IJavaScriptProject project = projects[i];
            if (!project.equals(projectOfRoot)) {
                this.updateProjectClasspath(rootPath, project, oldRoots);
            }
            ++i;
        }
    }

    protected void updateProjectClasspath(IPath rootPath, IJavaScriptProject project, Map oldRoots) throws JavaScriptModelException {
        oldRoots.put(project, project.getPackageFragmentRoots());
        IIncludePathEntry[] classpath = project.getRawIncludepath();
        IIncludePathEntry[] newClasspath = null;
        int cpLength = classpath.length;
        int newCPIndex = -1;
        int j = 0;
        while (j < cpLength) {
            IIncludePathEntry entry = classpath[j];
            if (rootPath.equals((Object)entry.getPath())) {
                if (newClasspath == null) {
                    newClasspath = new IIncludePathEntry[cpLength - 1];
                    System.arraycopy(classpath, 0, newClasspath, 0, j);
                    newCPIndex = j;
                }
            } else if (newClasspath != null) {
                newClasspath[newCPIndex++] = entry;
            }
            ++j;
        }
        if (newClasspath != null) {
            if (newCPIndex < newClasspath.length) {
                IIncludePathEntry[] iIncludePathEntryArray = newClasspath;
                newClasspath = new IIncludePathEntry[newCPIndex];
                System.arraycopy(iIncludePathEntryArray, 0, newClasspath, 0, newCPIndex);
            }
            project.setRawIncludepath(newClasspath, this.progressMonitor);
        }
    }

    @Override
    protected IJavaScriptModelStatus verify() {
        IJavaScriptModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getElementToProcess();
        if (root == null || !root.exists()) {
            return new JavaModelStatus(969, root);
        }
        IResource resource = root.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            return new JavaModelStatus(995, root);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

