/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;

public class TtlCache<K, V> {
    private final long m_ttl;
    private final TimeUnit m_timeUnit;
    private final ScheduledExecutorService m_executorService;
    private final Map<K, TtlCacheEntry<V>> m_cache;
    private ScheduledFuture<?> m_cleanupFuture;

    public TtlCache(long ttl, TimeUnit timeUnit) {
        this(ttl, timeUnit, null);
    }

    public TtlCache(long ttl, TimeUnit timeUnit, ScheduledExecutorService executorService) {
        this.m_timeUnit = Ensure.notNull(timeUnit);
        this.m_executorService = executorService;
        this.m_ttl = ttl;
        this.m_cache = new HashMap<K, TtlCacheEntry<V>>();
    }

    protected static void removeInvalidEntriesOf(Map<?, ? extends TtlCacheEntry<?>> cache) {
        cache.values().removeIf(TtlCacheEntry::elapsed);
    }

    public V get(K key) {
        TtlCacheEntry element = this.withCacheExec(it -> (TtlCacheEntry)it.get(key));
        if (element == null) {
            return null;
        }
        return (V)element.m_element;
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Ensure.notNull(mappingFunction);
        return (V)this.withCacheExec(cache -> cache.computeIfAbsent(key, (Function<Object, TtlCacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$computeIfAbsent$1(java.util.function.Function java.lang.Object ), (Ljava/lang/Object;)Lorg/eclipse/scout/sdk/core/util/TtlCache$TtlCacheEntry;)((TtlCache)this, (Function)mappingFunction)).m_element);
    }

    public V put(K key, V value) {
        TtlCacheEntry previous = this.withCacheExec(it -> it.put(key, new TtlCacheEntry<Object>(value, this.getTtl(), this.getTimeUnit())));
        if (previous == null) {
            return null;
        }
        return (V)previous.m_element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<K, TtlCacheEntry<V>> map = this.m_cache;
        synchronized (map) {
            this.m_cache.clear();
        }
    }

    public long getTtl() {
        return this.m_ttl;
    }

    public TimeUnit getTimeUnit() {
        return this.m_timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> R withCacheExec(Function<Map<K, TtlCacheEntry<V>>, R> function) {
        Map<K, TtlCacheEntry<V>> map = this.m_cache;
        synchronized (map) {
            boolean cacheHasTtl;
            boolean bl = cacheHasTtl = this.getTtl() > 0L;
            if (cacheHasTtl) {
                TtlCache.removeInvalidEntriesOf(this.m_cache);
            }
            R result = function.apply(this.m_cache);
            if (cacheHasTtl && !this.m_cache.isEmpty()) {
                this.scheduleCacheCleanup();
            }
            return result;
        }
    }

    protected void scheduleCacheCleanup() {
        if (this.m_executorService == null) {
            return;
        }
        ScheduledFuture<?> cleanupFuture = this.m_cleanupFuture;
        if (cleanupFuture != null) {
            cleanupFuture.cancel(false);
        }
        this.m_cleanupFuture = this.m_executorService.schedule(() -> this.withCacheExec(this::afterScheduledCacheCleanup), this.getTimeUnit().toMillis(this.getTtl()) + 1L, TimeUnit.MILLISECONDS);
    }

    protected Void afterScheduledCacheCleanup(Map<K, TtlCacheEntry<V>> cache) {
        SdkLog.debug("{} cleanup executed after {} {}. Remaining cached items: {}.", this.getClass().getSimpleName(), this.getTtl(), this.getTimeUnit().toString().toLowerCase(Locale.US), cache.size());
        return null;
    }

    private /* synthetic */ TtlCacheEntry lambda$computeIfAbsent$1(Function mappingFunction, Object k) {
        return new TtlCacheEntry(mappingFunction.apply(k), this.getTtl(), this.getTimeUnit());
    }

    protected static final class TtlCacheEntry<T> {
        private final T m_element;
        private final long m_validUntil;

        private TtlCacheEntry(T element, long ttl, TimeUnit timeUnit) {
            this.m_element = element;
            this.m_validUntil = System.currentTimeMillis() + timeUnit.toMillis(ttl);
        }

        boolean elapsed() {
            return System.currentTimeMillis() > this.m_validUntil;
        }
    }
}

