/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.form;

import java.util.Optional;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.java.builder.body.IScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.s.java.builder.body.ScoutMethodBodyBuilder;
import org.eclipse.scout.sdk.core.util.Strings;

public class HandlerMethodBodyGenerator
implements ISourceGenerator<IMethodBodyBuilder<?>> {
    public static final String FORM_DATA_VAR_NAME = "formData";
    private String m_serviceIfc;
    private String m_formDataType;
    private String m_permission;
    private ISourceGenerator<IMethodBodyBuilder<?>> m_methodArgGenerator;
    private ISourceGenerator<IMethodBodyBuilder<?>> m_permissionArgGenerator;
    private ISourceGenerator<IMethodBodyBuilder<?>> m_formDataInstanceGenerator;
    private boolean m_createFormDataInLoad;
    private final boolean m_isModify;

    public HandlerMethodBodyGenerator(boolean isModify) {
        this.m_isModify = isModify;
        this.m_createFormDataInLoad = true;
    }

    public void generate(IMethodBodyBuilder<?> builder) {
        IMethodGenerator declaringMethod = builder.surroundingMethod();
        String execLoadMethodName = ((IScoutApi)builder.context().requireApi(IScoutApi.class)).AbstractFormHandler().execLoadMethodName();
        boolean isLoad = execLoadMethodName.equals(declaringMethod.elementName(builder.context()).orElseThrow());
        this.serviceInterface().ifPresent(svcIfc -> this.buildBackendCall(ScoutMethodBodyBuilder.create(builder), (CharSequence)svcIfc, isLoad));
        if (isLoad && this.permission().isPresent()) {
            ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)builder.nl()).nl()).appendFrom(IScoutApi.class, api -> api.IWidget().setEnabledPermissionMethodName())).parenthesisOpen()).appendNew((CharSequence)this.permission().orElseThrow())).append(this.permissionArgGenerator().orElseGet(ISourceGenerator::empty).generalize(builder))).parenthesisClose()).parenthesisClose()).semicolon();
        }
    }

    protected void buildBackendCall(IScoutMethodBodyBuilder<?> builder, CharSequence serviceInterface, boolean isLoad) {
        boolean isDtoAvailable = this.formDataType().isPresent();
        if (isDtoAvailable) {
            ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)builder.ref(this.formDataType().orElseThrow())).space()).append(FORM_DATA_VAR_NAME)).equalSign();
            if (!isLoad || this.isCreateFormDataInLoad()) {
                ((IScoutMethodBodyBuilder)builder.append(this.formDataInstanceCreationGenerator().orElseGet(() -> b -> ((IMethodBodyBuilder)((IMethodBodyBuilder)((IMethodBodyBuilder)b.appendNew((CharSequence)this.formDataType().orElseThrow())).parenthesisClose()).semicolon()).nl()).generalize(builder))).appendExportFormData(FORM_DATA_VAR_NAME).nl();
                ((IScoutMethodBodyBuilder)builder.append(FORM_DATA_VAR_NAME)).equalSign();
            }
        }
        ((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)((IScoutMethodBodyBuilder)builder.appendBeansGet(serviceInterface).dot()).append(this.getBackendServiceMethodName(isLoad))).parenthesisOpen()).append(this.methodArgGenerator().orElseGet(() -> b -> {
            if (isDtoAvailable) {
                b.append(FORM_DATA_VAR_NAME);
            }
        }).generalize(builder))).parenthesisClose()).semicolon();
        if (isDtoAvailable) {
            ((IScoutMethodBodyBuilder)builder.nl()).appendImportFormData(FORM_DATA_VAR_NAME);
        }
    }

    protected String getBackendServiceMethodName(boolean isLoad) {
        if (isLoad) {
            if (this.isModify()) {
                return "load";
            }
            return "prepareCreate";
        }
        if (this.isModify()) {
            return "store";
        }
        return "create";
    }

    public Optional<String> serviceInterface() {
        return Strings.notBlank((CharSequence)this.m_serviceIfc);
    }

    public HandlerMethodBodyGenerator withServiceInterface(String serviceIfc) {
        this.m_serviceIfc = serviceIfc;
        return this;
    }

    public Optional<String> formDataType() {
        return Strings.notBlank((CharSequence)this.m_formDataType);
    }

    public HandlerMethodBodyGenerator withFormDataType(String formDataType) {
        this.m_formDataType = formDataType;
        return this;
    }

    public Optional<String> permission() {
        return Strings.notBlank((CharSequence)this.m_permission);
    }

    public HandlerMethodBodyGenerator withPermission(String permission) {
        this.m_permission = permission;
        return this;
    }

    public Optional<ISourceGenerator<IMethodBodyBuilder<?>>> methodArgGenerator() {
        return Optional.ofNullable(this.m_methodArgGenerator);
    }

    public HandlerMethodBodyGenerator withMethodArgGenerator(ISourceGenerator<IMethodBodyBuilder<?>> methodArgSourceBuilder) {
        this.m_methodArgGenerator = methodArgSourceBuilder;
        return this;
    }

    public Optional<ISourceGenerator<IMethodBodyBuilder<?>>> permissionArgGenerator() {
        return Optional.ofNullable(this.m_permissionArgGenerator);
    }

    public HandlerMethodBodyGenerator withPermissionArgGenerator(ISourceGenerator<IMethodBodyBuilder<?>> permissionArgSourceBuilder) {
        this.m_permissionArgGenerator = permissionArgSourceBuilder;
        return this;
    }

    public boolean isModify() {
        return this.m_isModify;
    }

    public Optional<ISourceGenerator<IMethodBodyBuilder<?>>> formDataInstanceCreationGenerator() {
        return Optional.ofNullable(this.m_formDataInstanceGenerator);
    }

    public HandlerMethodBodyGenerator withFormDataInstanceCreationGenerator(ISourceGenerator<IMethodBodyBuilder<?>> formDataInstanceCreationBuilder) {
        this.m_formDataInstanceGenerator = formDataInstanceCreationBuilder;
        return this;
    }

    public boolean isCreateFormDataInLoad() {
        return this.m_createFormDataInLoad;
    }

    public HandlerMethodBodyGenerator withCreateFormDataInLoad(boolean createFormDataInLoad) {
        this.m_createFormDataInLoad = createFormDataInLoad;
        return this;
    }
}

