/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.cli;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.base.BaseFeatureIdentifier;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.cli.ConsoleInteraction;
import org.eclipse.passage.lic.cli.Interaction;
import org.eclipse.passage.lic.cli.LicenseCoverageCheck;
import org.eclipse.passage.lic.equinox.EquinoxPassage;

public final class LicenseProtection {
    private Optional<GrantLockAttempt> lock = Optional.empty();
    private final Supplier<Interaction> interaction;

    public LicenseProtection() {
        this(ConsoleInteraction::new);
    }

    public LicenseProtection(Supplier<Interaction> interaction) {
        this.interaction = interaction;
    }

    public boolean check() {
        if (this.licenseCoverageIsNotSufficient()) {
            return false;
        }
        return this.locAcquired();
    }

    public void release() {
        this.lock.ifPresent(acq -> {
            ServiceInvocationResult serviceInvocationResult = new EquinoxPassage().releaseLicense(acq);
        });
    }

    private boolean locAcquired() {
        Optional<GrantLockAttempt> attempt = this.acquireLicense();
        if (!attempt.isPresent()) {
            return false;
        }
        if (!attempt.get().successful()) {
            return false;
        }
        this.lock = attempt;
        return true;
    }

    private boolean licenseCoverageIsNotSufficient() {
        return !LicenseCoverageCheck.Result.proceed.equals((Object)new LicenseCoverageCheck(this.interaction.get()).run());
    }

    private Optional<GrantLockAttempt> acquireLicense() {
        return this.product().flatMap(this::acquireLicense);
    }

    private Optional<LicensedProduct> product() {
        ServiceInvocationResult product = new EquinoxPassage().product();
        if (!product.data().isPresent()) {
            System.err.printf("Failed to read product credentials:%s\n", new DiagnosticExplained(product.diagnostic()).get());
        }
        return product.data();
    }

    private Optional<GrantLockAttempt> acquireLicense(LicensedProduct product) {
        ServiceInvocationResult response = new EquinoxPassage().acquireLicense((FeatureIdentifier)new BaseFeatureIdentifier(product.identifier()));
        if (!this.successful((ServiceInvocationResult<GrantLockAttempt>)response)) {
            System.err.printf("Failed to acquire license \nfor product %s:\n%s\n", product, new DiagnosticExplained(response.diagnostic()).get());
            return Optional.empty();
        }
        return Optional.of((GrantLockAttempt)response.data().get());
    }

    private boolean successful(ServiceInvocationResult<GrantLockAttempt> response) {
        return response.data().map(GrantLockAttempt::successful).orElse(Boolean.FALSE);
    }
}

