/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.util.List;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.lpg.FormattingHelper;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.VoidType;

public class AbstractFormattingHelper
implements FormattingHelper {
    public static final AbstractFormattingHelper INSTANCE = new AbstractFormattingHelper();

    @Override
    public String formatClass(Object object) {
        if (object == null) {
            return "<null-class>";
        }
        return object.getClass().getName();
    }

    @Override
    public String formatEClassName(EObject eObject) {
        if (eObject == null) {
            return "<null-eObject>";
        }
        return this.formatName(eObject.eClass());
    }

    @Override
    public String formatName(Object object) {
        if (object == null) {
            return this.formatString(null);
        }
        if (object instanceof ENamedElement) {
            return this.formatString(((ENamedElement)object).getName());
        }
        return object.getClass().getName();
    }

    protected String getSeparator() {
        return "::";
    }

    @Override
    public String formatQualifiedName(Object object) {
        EObject container;
        if (object instanceof EObject && (container = ((EObject)object).eContainer()) != null) {
            return String.valueOf(this.formatQualifiedName(container)) + this.getSeparator() + this.formatName(object);
        }
        return this.formatName(object);
    }

    @Override
    public String formatPath(List<String> pathName) {
        StringBuilder s = new StringBuilder();
        if (pathName != null) {
            int iMax = pathName.size();
            int i = 0;
            while (i < iMax) {
                s.append(this.formatString(pathName.get(i)));
                if (i + 1 < iMax) {
                    s.append("::");
                }
                ++i;
            }
        }
        return s.toString();
    }

    @Override
    public String formatPath(List<String> pathName, String name) {
        StringBuilder s = new StringBuilder();
        if (pathName != null) {
            int iMax = pathName.size();
            int i = 0;
            while (i < iMax) {
                s.append(this.formatString(pathName.get(i)));
                s.append(i + 1 < iMax ? this.getSeparator() : ".");
                ++i;
            }
        }
        s.append(this.formatString(name));
        return s.toString();
    }

    @Override
    public String formatString(String name) {
        return name != null ? name : "<null>";
    }

    @Override
    public String formatType(Object type) {
        if (type instanceof VoidType) {
            return "<void-type>";
        }
        if (type instanceof TypeType) {
            return "<type-type>";
        }
        if (type instanceof InvalidType) {
            return "<invalid-type>";
        }
        if (type instanceof AnyType) {
            return "<any-type>";
        }
        if (type instanceof CollectionType) {
            StringBuilder s = new StringBuilder();
            s.append(((CollectionType)type).getKind().toString());
            s.append('(');
            s.append(this.formatType(((CollectionType)type).getElementType()));
            s.append(')');
            return s.toString();
        }
        return this.formatName(type);
    }
}

