/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.resource;

import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.parsley.resource.ResourceSaveStrategy;
import org.eclipse.emf.parsley.validation.IssueReporter;
import org.eclipse.emf.parsley.validation.ValidationRunner;

public class ValidateBeforeSaveStrategy
extends ResourceSaveStrategy {
    @Inject
    private ValidationRunner validationRunner;
    @Inject
    private IssueReporter issueReporter;

    @Override
    public boolean save(Resource resource) throws IOException {
        if (!this.precondition(resource)) {
            return false;
        }
        return super.save(resource);
    }

    protected boolean precondition(Resource resource) {
        return this.validationRunner.validate(resource, this.issueReporter).isEmpty();
    }
}

