/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.versions.core.spi;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class ScmResourceUtils {
    public static IProject[] getProjects() {
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] projects = root.getRoot().getProjects();
        return projects;
    }

    public static IProject getProject(String name) {
        IWorkspace root = ResourcesPlugin.getWorkspace();
        IProject[] projects = root.getRoot().getProjects();
        IProject project = null;
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project2 = iProjectArray[n2];
                project = project2;
                if (project.getName().equals(name)) {
                    return project;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IFile getWorkSpaceFile(URI aFilePathURI, IProject aProject) {
        IFile[] files;
        IFile[] iFileArray = files = ScmResourceUtils.getWorkSpaceFiles(aFilePathURI);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile iFile = iFileArray[n2];
            if (iFile.getProject().equals((Object)aProject)) {
                return iFile;
            }
            ++n2;
        }
        return null;
    }

    public static IFile[] getWorkSpaceFiles(URI filePathURI) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = null;
        if (filePathURI != null) {
            files = ScmResourceUtils.filterNonExistentFiles(root.findFilesForLocationURI(filePathURI));
        }
        return files;
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            } else if (files[i].getType() == 1) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }
}

