/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.feature.FeatureObject;
import org.eclipse.pde.internal.core.feature.FeatureURLElement;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureURL
extends FeatureObject
implements IFeatureURL {
    private static final long serialVersionUID = 1L;
    private IFeatureURLElement fUpdate;
    private final Vector<IFeatureURLElement> fDiscoveries = new Vector();

    @Override
    public void addDiscovery(IFeatureURLElement discovery) throws CoreException {
        this.ensureModelEditable();
        this.fDiscoveries.add(discovery);
        ((FeatureURLElement)discovery).setInTheModel(true);
        this.fireStructureChanged(discovery, 1);
    }

    @Override
    public void setUpdate(IFeatureURLElement update) throws CoreException {
        this.ensureModelEditable();
        if (this.fUpdate == update) {
            return;
        }
        if (this.fUpdate != null) {
            ((FeatureURLElement)this.fUpdate).setInTheModel(false);
        }
        IFeatureURLElement oldValue = this.fUpdate;
        this.fUpdate = update;
        if (oldValue != null) {
            this.fireStructureChanged(oldValue, 2);
        }
        if (update != null) {
            ((FeatureURLElement)update).setInTheModel(true);
            this.fireStructureChanged(update, 1);
        }
    }

    @Override
    public IFeatureURLElement[] getDiscoveries() {
        return this.fDiscoveries.toArray(new IFeatureURLElement[this.fDiscoveries.size()]);
    }

    @Override
    public IFeatureURLElement getUpdate() {
        return this.fUpdate;
    }

    @Override
    protected void parse(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String tag = child.getNodeName().toLowerCase(Locale.ENGLISH);
                int urlType = -1;
                if (tag.equals("update")) {
                    urlType = 1;
                } else if (tag.equals("discovery")) {
                    urlType = 2;
                }
                if (urlType != -1) {
                    IFeatureURLElement element = this.getModel().getFactory().createURLElement(this, urlType);
                    ((FeatureURLElement)element).parse(child);
                    if (urlType == 1) {
                        ((FeatureURLElement)element).setInTheModel(true);
                        this.fUpdate = element;
                    } else if (urlType == 2) {
                        ((FeatureURLElement)element).setInTheModel(true);
                        this.fDiscoveries.add(element);
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void removeDiscovery(IFeatureURLElement discovery) throws CoreException {
        this.ensureModelEditable();
        this.fDiscoveries.remove(discovery);
        ((FeatureURLElement)discovery).setInTheModel(false);
        this.fireStructureChanged(discovery, 2);
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.fUpdate == null && this.fDiscoveries.isEmpty()) {
            return;
        }
        writer.println();
        writer.println(indent + "<url>");
        String indent2 = indent + "   ";
        if (this.fUpdate != null) {
            this.fUpdate.write(indent2, writer);
        }
        int i = 0;
        while (i < this.fDiscoveries.size()) {
            IFeatureURLElement element = this.fDiscoveries.elementAt(i);
            element.write(indent2, writer);
            ++i;
        }
        writer.println(indent + "</url>");
    }
}

