/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.Resources;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.CompressBarSeries;
import org.eclipse.swtchart.internal.compress.CompressScatterSeries;
import org.eclipse.swtchart.internal.series.Messages;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;

public class BarSeries<T>
extends Series<T>
implements IBarSeries<T> {
    private int riserIndex;
    private Color barColor = Display.getDefault().getSystemColor(13);
    private int barWidth = 20;
    private int padding = 20;
    private boolean barOverlay = false;
    private IBarSeries.BarWidthStyle barWidthStyle = IBarSeries.BarWidthStyle.STRETCHED;
    public static final int INITIAL_BAR_WIDTH = 20;
    public static final int INITIAL_PADDING = 20;
    private static final int ALPHA = 208;
    private static final int MARGIN_AT_MIN_MAX_PLOT = 6;
    private static final int DEFAULT_BAR_COLOR = 13;

    protected BarSeries(Chart chart, String id) {
        super(chart, id);
        this.type = ISeries.SeriesType.BAR;
        this.compressor = new CompressBarSeries();
    }

    @Override
    public IBarSeries.BarWidthStyle getBarWidthStyle(IBarSeries.BarWidthStyle style) {
        return this.barWidthStyle;
    }

    @Override
    public void setBarWidthStyle(IBarSeries.BarWidthStyle style) {
        this.barWidthStyle = style;
    }

    @Override
    public int getBarWidth() {
        return this.barWidth;
    }

    @Override
    public void setBarWidth(int width) {
        if (width <= 0) {
            SWT.error((int)5);
        }
        this.barWidth = width;
    }

    @Override
    public int getBarPadding() {
        return this.padding;
    }

    @Override
    public void setBarPadding(int padding) {
        if (padding < 0 || padding > 100) {
            SWT.error((int)5);
        }
        this.padding = padding;
    }

    @Override
    public boolean isBarOverlay() {
        return this.barOverlay;
    }

    @Override
    public void setBarOverlay(boolean barOverlay) {
        this.barOverlay = barOverlay;
    }

    @Override
    public Color getBarColor() {
        if (this.barColor.isDisposed()) {
            this.barColor = Display.getDefault().getSystemColor(13);
        }
        return this.barColor;
    }

    @Override
    public void setBarColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.barColor = color == null ? Display.getDefault().getSystemColor(13) : color;
    }

    @Override
    public Rectangle[] getBounds() {
        Rectangle[] compressedBounds = this.getBoundsForCompressedSeries();
        if (((Axis)this.chart.getAxisSet().getXAxis(this.xAxisId)).isValidCategoryAxis()) {
            return compressedBounds;
        }
        double[] xSeries = this.getXSeries();
        Rectangle[] rs = new Rectangle[xSeries.length];
        double[] comporessedXSeries = this.compressor.getCompressedXSeries();
        int cnt = 0;
        int i = 0;
        while (i < xSeries.length) {
            if (cnt < comporessedXSeries.length && comporessedXSeries[cnt] == xSeries[i]) {
                if (compressedBounds[cnt].width != 0 && compressedBounds[cnt].height != 0) {
                    rs[i] = compressedBounds[cnt];
                }
                ++cnt;
            }
            ++i;
        }
        return rs;
    }

    public Rectangle[] getBoundsForCompressedSeries() {
        Axis xAxis = (Axis)this.chart.getAxisSet().getXAxis(this.xAxisId);
        Axis yAxis = (Axis)this.chart.getAxisSet().getYAxis(this.yAxisId);
        double[] xseries = this.compressor.getCompressedXSeries();
        double[] yseries = this.compressor.getCompressedYSeries();
        int[] indexes = this.compressor.getCompressedIndexes();
        if (xAxis.isValidCategoryAxis()) {
            int i = 0;
            while (i < xseries.length) {
                xseries[i] = indexes[i];
                ++i;
            }
        }
        Rectangle[] rectangles = new Rectangle[xseries.length];
        Range xRange = xAxis.getRange();
        Range yRange = yAxis.getRange();
        int i = 0;
        while (i < xseries.length) {
            int x = xAxis.getPixelCoordinate(xseries[i]);
            int y = yAxis.getPixelCoordinate(this.isValidStackSeries() ? this.stackSeries[indexes[i]] : yseries[i]);
            double baseYCoordinate = yAxis.getRange().lower > 0.0 ? yAxis.getRange().lower : 0.0;
            double riserwidth = this.getRiserWidth(xseries, i, xAxis, xRange.lower, xRange.upper);
            double riserHeight = Math.abs(yAxis.getPixelCoordinate(yseries[i], yRange.lower, yRange.upper) - yAxis.getPixelCoordinate(yAxis.isLogScaleEnabled() ? yRange.lower : baseYCoordinate, yRange.lower, yRange.upper));
            int riserCnt = xAxis.getNumRisers();
            if (riserCnt > 1 && !this.barOverlay) {
                x = xAxis.isHorizontalAxis() ? (int)((double)x - riserwidth / 2.0 + riserwidth / (double)riserCnt * ((double)this.riserIndex + 0.5)) : (int)((double)x - riserwidth / 2.0 + riserwidth / (double)riserCnt * ((double)(riserCnt - this.riserIndex) - 0.5));
                riserwidth /= (double)riserCnt;
            }
            if (xAxis.isHorizontalAxis()) {
                int width;
                if (y > yAxis.getPixelCoordinate(0.0)) {
                    y = yAxis.getPixelCoordinate(0.0);
                }
                width = (width = (int)Math.ceil(riserwidth)) == 0 ? 1 : width;
                rectangles[i] = this.getVisibleRectangle((int)Math.floor((double)x - riserwidth / 2.0), y, width, (int)riserHeight);
            } else {
                int height;
                if (y < yAxis.getPixelCoordinate(0.0)) {
                    y = yAxis.getPixelCoordinate(0.0);
                }
                height = (height = (int)Math.ceil(riserwidth)) == 0 ? 1 : height;
                rectangles[i] = this.getVisibleRectangle((int)((double)y - riserHeight), (int)Math.floor((double)x - riserwidth / 2.0), (int)riserHeight, height);
            }
            ++i;
        }
        return rectangles;
    }

    private Rectangle getVisibleRectangle(int x, int y, int width, int height) {
        int offset = 5;
        int newX = x;
        int newY = y;
        int newWidth = width;
        int newHeight = height;
        if (x < 0) {
            newX = -5;
            newWidth += x + 5;
        }
        if (y < 0) {
            newY = -5;
            newHeight += y + 5;
        }
        Point size = this.chart.getPlotArea().getSize();
        if (x + width > size.x && (newWidth -= x + width - size.x + 5) < 0) {
            newWidth = 0;
        }
        if (y + height > size.y && (newHeight -= y + height - size.y + 5) < 0) {
            newHeight = 0;
        }
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    protected void setRiserIndex(int riserIndex) {
        this.riserIndex = riserIndex;
    }

    @Override
    protected void setCompressor() {
        CartesianSeriesModel dataModel = this.getDataModel();
        if (dataModel instanceof DoubleArraySeriesModel && ((DoubleArraySeriesModel)dataModel).isXMonotoneIncreasing()) {
            this.compressor = new CompressBarSeries();
            return;
        }
        this.compressor = new CompressScatterSeries();
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        Range range;
        int upperPlotMargin;
        int lowerPlotMargin;
        if (axis.getDirection() == IAxis.Direction.X) {
            double[] xSeries = this.getXSeries();
            Range xRange = this.getXRange();
            double lowerRiserWidth = this.getRiserWidth(xSeries, 0, axis, xRange.lower, xRange.upper);
            double upperRiserWidth = this.getRiserWidth(xSeries, xSeries.length - 1, axis, xRange.lower, xRange.upper);
            lowerPlotMargin = (int)(lowerRiserWidth / 2.0 + 6.0);
            upperPlotMargin = (int)(upperRiserWidth / 2.0 + 6.0);
            range = this.getXRange();
        } else {
            range = this.getYRange();
            if (range.upper < 0.0) {
                range.upper = 0.0;
            }
            if (range.lower > 0.0) {
                range.lower = axis.isLogScaleEnabled() ? range.lower : 0.0;
            }
            lowerPlotMargin = range.lower == 0.0 ? 0 : 6;
            upperPlotMargin = range.upper == 0.0 ? 0 : 6;
        }
        return this.getRangeWithMargin(lowerPlotMargin, upperPlotMargin, length, axis, range);
    }

    private int getRiserWidth(double[] series, int index, Axis xAxis, double min, double max) {
        double lower;
        double upper;
        if (series.length == 0) {
            return 1;
        }
        if (series.length == 1) {
            upper = series[0] + 0.5;
            lower = series[0] - 0.5;
        } else if (index != series.length - 1 && (index == 0 || series[index + 1] - series[index] < series[index] - series[index - 1])) {
            upper = series[index + 1];
            lower = series[index];
        } else {
            upper = series[index];
            lower = series[index - 1];
        }
        if (this.barWidthStyle == IBarSeries.BarWidthStyle.STRETCHED) {
            int width = Math.abs(xAxis.getPixelCoordinate(upper, min, max) - xAxis.getPixelCoordinate(lower, min, max));
            if ((width = (int)((double)width * ((double)(100 - this.padding) / 100.0))) == 0) {
                width = 1;
            }
            return width;
        }
        if (this.barWidthStyle == IBarSeries.BarWidthStyle.FIXED) {
            return this.barWidth;
        }
        throw new IllegalStateException(Messages.getString("UNKNOWN_BAR_WIDTH_STYLE"));
    }

    private static Color getFrameColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        red = (int)((double)red * (red > 128 ? 0.8 : 1.2));
        green = (int)((double)green * (green > 128 ? 0.8 : 1.2));
        blue = (int)((double)blue * (blue > 128 ? 0.8 : 1.2));
        return Resources.getColor(red, green, blue);
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        Rectangle[] rs = this.getBoundsForCompressedSeries();
        int i = 0;
        while (i < rs.length) {
            this.drawRiser(gc, rs[i].x, rs[i].y, rs[i].width, rs[i].height);
            ++i;
        }
        if (this.seriesLabel.isVisible() || this.xErrorBar.isVisible() || this.yErrorBar.isVisible()) {
            double[] xSeries = this.getXSeries();
            double[] ySeries = this.getYSeries();
            double[] yseries = this.compressor.getCompressedYSeries();
            int[] indexes = this.compressor.getCompressedIndexes();
            int i2 = 0;
            while (i2 < rs.length) {
                int v;
                int h;
                this.seriesLabel.draw(gc, rs[i2].x + rs[i2].width / 2, rs[i2].y + rs[i2].height / 2, yseries[i2], indexes[i2], 0x1000000);
                if (xAxis.isHorizontalAxis()) {
                    h = xAxis.isCategoryEnabled() ? rs[i2].x + rs[i2].width / 2 : xAxis.getPixelCoordinate(xSeries[indexes[i2]]);
                    v = yAxis.getPixelCoordinate(ySeries[indexes[i2]]);
                } else {
                    v = xAxis.isCategoryEnabled() ? rs[i2].y + rs[i2].height / 2 : xAxis.getPixelCoordinate(xSeries[indexes[i2]]);
                    h = yAxis.getPixelCoordinate(ySeries[indexes[i2]]);
                }
                this.xErrorBar.draw(gc, h, v, xAxis, indexes[i2]);
                this.yErrorBar.draw(gc, h, v, yAxis, indexes[i2]);
                ++i2;
            }
        }
    }

    private void drawRiser(GC gc, int h, int v, int width, int height) {
        int alpha = gc.getAlpha();
        gc.setAlpha(208);
        Color oldBackground = gc.getBackground();
        gc.setBackground(this.getBarColor());
        gc.fillRectangle(h, v, width, height);
        gc.setLineStyle(1);
        Color frameColor = BarSeries.getFrameColor(this.getBarColor());
        Color oldForeground = gc.getForeground();
        gc.setForeground(frameColor);
        gc.drawRectangle(h, v, width, height);
        gc.setAlpha(alpha);
        gc.setBackground(oldBackground);
        gc.setForeground(oldForeground);
    }
}

