/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.theme.ThemeTrieElementRule;
import org.eclipse.tm4e.core.internal.utils.StringUtils;

public final class ThemeTrieElement {
    private final ThemeTrieElementRule _mainRule;
    private final List<ThemeTrieElementRule> _rulesWithParentScopes;
    private final Map<String, ThemeTrieElement> _children;

    public ThemeTrieElement(ThemeTrieElementRule mainRule) {
        this(mainRule, new ArrayList<ThemeTrieElementRule>(), new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes) {
        this(mainRule, rulesWithParentScopes, new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes, Map<String, ThemeTrieElement> children) {
        this._mainRule = mainRule;
        this._rulesWithParentScopes = rulesWithParentScopes;
        this._children = children;
    }

    private static int _cmpBySpecificity(ThemeTrieElementRule a, ThemeTrieElementRule b) {
        if (a.scopeDepth != b.scopeDepth) {
            return b.scopeDepth - a.scopeDepth;
        }
        int aParentIndex = 0;
        int bParentIndex = 0;
        int aParentScopesSize = a.parentScopes.size();
        int bParentScopesSize = b.parentScopes.size();
        while (true) {
            if (aParentScopesSize > aParentIndex && ">".equals(a.parentScopes.get(aParentIndex))) {
                ++aParentIndex;
            }
            if (bParentScopesSize > bParentIndex && ">".equals(b.parentScopes.get(bParentIndex))) {
                ++bParentIndex;
            }
            if (aParentIndex >= aParentScopesSize || bParentIndex >= bParentScopesSize) break;
            int parentScopeLengthDiff = b.parentScopes.get(bParentIndex).length() - a.parentScopes.get(aParentIndex).length();
            if (parentScopeLengthDiff != 0) {
                return parentScopeLengthDiff;
            }
            ++aParentIndex;
            ++bParentIndex;
        }
        return bParentScopesSize - aParentScopesSize;
    }

    public List<ThemeTrieElementRule> match(String scope) {
        if (!scope.isEmpty()) {
            String tail;
            String head;
            int dotIndex = scope.indexOf(46);
            if (dotIndex == -1) {
                head = scope;
                tail = "";
            } else {
                head = scope.substring(0, dotIndex);
                tail = scope.substring(dotIndex + 1);
            }
            ThemeTrieElement child = this._children.get(head);
            if (child != null) {
                return child.match(tail);
            }
        }
        ArrayList<ThemeTrieElementRule> rules = new ArrayList<ThemeTrieElementRule>(this._rulesWithParentScopes);
        rules.add(this._mainRule);
        rules.sort(ThemeTrieElement::_cmpBySpecificity);
        return rules;
    }

    public void insert(int scopeDepth, String scope, @Nullable List<String> parentScopes, int fontStyle, int foreground, int background) {
        String tail;
        String head;
        if (scope.isEmpty()) {
            this.doInsertHere(scopeDepth, parentScopes, fontStyle, foreground, background);
            return;
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        ThemeTrieElement child = this._children.computeIfAbsent(head, key -> new ThemeTrieElement(this._mainRule.clone(), ThemeTrieElementRule.cloneArr(this._rulesWithParentScopes)));
        child.insert(scopeDepth + 1, tail, parentScopes, fontStyle, foreground, background);
    }

    private void doInsertHere(int scopeDepth, @Nullable List<String> parentScopes, int fontStyle, int foreground, int background) {
        if (parentScopes == null) {
            this._mainRule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        for (ThemeTrieElementRule rule : this._rulesWithParentScopes) {
            if (StringUtils.strArrCmp(rule.parentScopes, parentScopes) != 0) continue;
            rule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        if (fontStyle == -1) {
            fontStyle = this._mainRule.fontStyle;
        }
        if (foreground == 0) {
            foreground = this._mainRule.foreground;
        }
        if (background == 0) {
            background = this._mainRule.background;
        }
        this._rulesWithParentScopes.add(new ThemeTrieElementRule(scopeDepth, parentScopes, fontStyle, foreground, background));
    }

    public int hashCode() {
        int result = 31 + this._children.hashCode();
        result = 31 * result + this._mainRule.hashCode();
        return 31 * result + this._rulesWithParentScopes.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ThemeTrieElement) {
            ThemeTrieElement other = (ThemeTrieElement)obj;
            return this._children.equals(other._children) && this._mainRule.equals(other._mainRule) && this._rulesWithParentScopes.equals(other._rulesWithParentScopes);
        }
        return false;
    }
}

