/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.DOMToIndexVisitor;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchNameEnvironment;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class SourceIndexer
extends AbstractIndexer
implements ITypeRequestor,
SuffixConstants {
    private LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    public ISourceElementRequestor requestor = new SourceIndexerRequestor(this);
    private Parser basicParser;
    private org.eclipse.jdt.internal.core.jdom.CompilationUnit compilationUnit;
    private CompilationUnitDeclaration cud;
    private ASTNode dom;
    private static final boolean DEBUG = false;

    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    private boolean usedDomBasedIndexing() {
        return Boolean.getBoolean(this.getClass().getSimpleName() + ".DOM_BASED_INDEXER");
    }

    @Override
    public void indexDocument() {
        block9: {
            if (this.usedDomBasedIndexing()) {
                this.indexDocumentFromDOM();
                return;
            }
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.getParser();
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaCore.create(project), this.requestor);
            } else {
                parser.setRequestor(this.requestor);
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (source == null || name == null) {
                return;
            }
            this.compilationUnit = new org.eclipse.jdt.internal.core.jdom.CompilationUnit(source, name);
            try {
                if (parser.parseCompilationUnit(this.compilationUnit, true, null).hasFunctionalTypes()) {
                    this.document.requireIndexingResolvedDocument();
                }
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block9;
                JavaModelManager.trace("", e);
            }
        }
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding, accessRestriction);
    }

    public void accept(ICompilationUnit unit, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(unit, 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration parsedUnit = this.basicParser.dietParse(unit, unitResult);
        this.lookupEnvironment.buildTypeBindings(parsedUnit, accessRestriction);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
        IType type = elementInfo.getHandle();
        ICompilationUnit sourceUnit = (ICompilationUnit)type.getCompilationUnit();
        this.accept(sourceUnit, accessRestriction);
    }

    public void resolveDocument() {
        block4: {
            org.eclipse.jdt.core.ICompilationUnit iCompilationUnit;
            if (this.usedDomBasedIndexing() && this.dom != null && (iCompilationUnit = this.getUnit()) instanceof CompilationUnit) {
                CompilationUnit unit = (CompilationUnit)iCompilationUnit;
                this.resolveDocumentDomImpl(unit);
            } else {
                try {
                    Path path = new Path(this.document.getPath());
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                    JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
                    JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)project);
                    this.options = new CompilerOptions(javaProject.getOptions(true));
                    ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, (IProblemFactory)new DefaultProblemFactory());
                    this.basicParser = new Parser(problemReporter, false);
                    this.basicParser.reportOnlyOneSyntaxError = true;
                    this.basicParser.scanner.taskTags = null;
                    this.cud = this.basicParser.parse((ICompilationUnit)this.compilationUnit, new CompilationResult((ICompilationUnit)this.compilationUnit, 0, 0, this.options.maxProblemsPerUnit));
                    JavaSearchNameEnvironment nameEnvironment = new JavaSearchNameEnvironment(javaProject, JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, true));
                    this.lookupEnvironment = new LookupEnvironment((ITypeRequestor)this, this.options, problemReporter, (INameEnvironment)nameEnvironment);
                    this.reduceParseTree(this.cud);
                    this.lookupEnvironment.buildTypeBindings(this.cud, null);
                    this.lookupEnvironment.completeTypeBindings();
                    this.cud.scope.faultInTypes();
                    this.cud.resolve();
                }
                catch (Exception e) {
                    if (!JobManager.VERBOSE) break block4;
                    JavaModelManager.trace("", e);
                }
            }
        }
    }

    private void resolveDocumentDomImpl(CompilationUnit unit) {
        String reducedDOM = this.reduceDOM(this.dom);
        try {
            ASTParser astParser = ASTParser.newParser(AST.getJLSLatest());
            astParser.setSource(unit);
            astParser.setSource(reducedDOM.toCharArray());
            astParser.setStatementsRecovery(true);
            astParser.setResolveBindings(true);
            this.dom = astParser.createAST(null);
        }
        catch (Exception e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
    }

    private String reduceDOM(ASTNode domParam) {
        domParam.accept(new ASTVisitor(false){
            private boolean requiresBinding;
            {
                this.requiresBinding = false;
            }

            @Override
            public boolean visit(TypeDeclaration node) {
                node.setJavadoc(null);
                return super.visit(node);
            }

            @Override
            public boolean visit(RecordDeclaration node) {
                node.setJavadoc(null);
                return super.visit(node);
            }

            @Override
            public boolean visit(AnnotationTypeDeclaration node) {
                node.setJavadoc(null);
                return super.visit(node);
            }

            @Override
            public boolean visit(FieldDeclaration node) {
                node.setJavadoc(null);
                return super.visit(node);
            }

            @Override
            public boolean visit(MethodDeclaration node) {
                AbstractTypeDeclaration type;
                node.setJavadoc(null);
                ASTNode aSTNode = node.getParent();
                if (aSTNode instanceof AbstractTypeDeclaration && (type = (AbstractTypeDeclaration)aSTNode).getParent() instanceof org.eclipse.jdt.core.dom.CompilationUnit) {
                    this.requiresBinding = false;
                }
                return super.visit(node);
            }

            @Override
            public void endVisit(MethodDeclaration node) {
                AbstractTypeDeclaration type;
                ASTNode aSTNode;
                if (!this.requiresBinding && (aSTNode = node.getParent()) instanceof AbstractTypeDeclaration && (type = (AbstractTypeDeclaration)aSTNode).getParent() instanceof org.eclipse.jdt.core.dom.CompilationUnit && node.getBody() != null) {
                    node.getBody().statements().clear();
                }
            }

            @Override
            public boolean visit(ExpressionMethodReference methodRef) {
                this.requiresBinding = true;
                return false;
            }

            @Override
            public boolean visit(CreationReference methodRef) {
                this.requiresBinding = true;
                return false;
            }

            @Override
            public boolean visit(SuperMethodReference methodRef) {
                this.requiresBinding = true;
                return false;
            }

            @Override
            public boolean visit(TypeMethodReference methodRef) {
                this.requiresBinding = true;
                return false;
            }

            @Override
            public boolean visit(LambdaExpression methodRef) {
                this.requiresBinding = true;
                return false;
            }
        });
        return domParam.toString();
    }

    private void reduceParseTree(CompilationUnitDeclaration unit) {
        org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] types = unit.types;
        int i = 0;
        int l = types == null ? 0 : types.length;
        while (i < l) {
            this.purgeMethodStatements(types[i]);
            ++i;
        }
    }

    private void purgeMethodStatements(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration type) {
        AbstractMethodDeclaration[] methods = type.methods;
        int j = 0;
        int length = methods == null ? 0 : methods.length;
        while (j < length) {
            AbstractMethodDeclaration method = methods[j];
            if (method != null && (method.bits & 0x200002) == 0) {
                method.statements = null;
                method.javadoc = null;
            }
            ++j;
        }
        org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            org.eclipse.jdt.internal.compiler.ast.TypeDeclaration[] typeDeclarationArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.jdt.internal.compiler.ast.TypeDeclaration memberType = typeDeclarationArray[n2];
                this.purgeMethodStatements(memberType);
                ++n2;
            }
        }
    }

    @Override
    public void indexResolvedDocument() {
        block10: {
            if (this.usedDomBasedIndexing() && this.dom != null) {
                this.dom.accept(new DOMToIndexVisitor(this));
                this.dom = null;
                return;
            }
            try {
                int i = 0;
                int length = this.cud.functionalExpressionsCount;
                while (i < length) {
                    FunctionalExpression expression = this.cud.functionalExpressions[i];
                    if (expression instanceof org.eclipse.jdt.internal.compiler.ast.LambdaExpression) {
                        org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression = (org.eclipse.jdt.internal.compiler.ast.LambdaExpression)expression;
                        if (lambdaExpression.binding != null && lambdaExpression.binding.isValidBinding()) {
                            char[] superinterface = lambdaExpression.resolvedType.sourceName();
                            this.addIndexEntry(IIndexConstants.METHOD_DECL, MethodPattern.createIndexKey(lambdaExpression.descriptor.selector, lambdaExpression.descriptor.parameters.length));
                            this.addClassDeclaration(0, CharOperation.NO_CHAR, ONE_ZERO, ONE_ZERO_CHAR, CharOperation.NO_CHAR, new char[][]{superinterface}, CharOperation.NO_CHAR_CHAR, true);
                        }
                    } else {
                        MethodBinding binding;
                        ReferenceExpression referenceExpression = (ReferenceExpression)expression;
                        if (!referenceExpression.isArrayConstructorReference() && (binding = referenceExpression.getMethodBinding()) != null && binding.isValidBinding()) {
                            if (referenceExpression.isMethodReference()) {
                                this.addMethodReference(binding.selector, binding.parameters.length);
                            } else {
                                this.addConstructorReference(binding.declaringClass.sourceName(), binding.parameters.length);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block10;
                JavaModelManager.trace("", e);
            }
        }
    }

    private org.eclipse.jdt.core.ICompilationUnit getUnit() {
        SearchDocument searchDocument = this.document;
        if (searchDocument instanceof JavaSearchDocument) {
            JavaSearchDocument javaSearchDoc = (JavaSearchDocument)searchDocument;
            IFile file = javaSearchDoc.getFile();
            try {
                IJavaProject javaProject;
                IPackageFragment fragment;
                if (JavaProject.hasJavaNature(file.getProject()) && (fragment = (javaProject = JavaCore.create(file.getProject())).findPackageFragment(file.getFullPath().removeLastSegments(1))) != null) {
                    return fragment.getCompilationUnit(file.getName());
                }
            }
            catch (Exception ex) {
                ILog.get().error("Failed to index document from DOM for " + this.document.getPath(), (Throwable)ex);
            }
        }
        return null;
    }

    boolean indexDocumentFromDOM() {
        org.eclipse.jdt.core.ICompilationUnit unit = this.getUnit();
        ASTParser astParser = ASTParser.newParser(AST.getJLSLatest());
        if (unit != null) {
            astParser.setSource(unit);
        } else {
            astParser.setSource(this.document.getCharContents());
        }
        astParser.setStatementsRecovery(true);
        astParser.setResolveBindings(this.document.shouldIndexResolvedDocument());
        ASTNode domLocal = astParser.createAST(null);
        if (domLocal != null) {
            domLocal.accept(new DOMToIndexVisitor(this));
            domLocal.accept(new ASTVisitor(){

                @Override
                public boolean preVisit2(ASTNode node) {
                    if (SourceIndexer.this.document.shouldIndexResolvedDocument()) {
                        return false;
                    }
                    if (node instanceof MethodReference || node instanceof LambdaExpression) {
                        SourceIndexer.this.document.requireIndexingResolvedDocument();
                        return false;
                    }
                    return true;
                }
            });
            if (this.document.shouldIndexResolvedDocument()) {
                this.dom = domLocal;
            }
            return true;
        }
        return false;
    }
}

