/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ArchiveURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.ArchiveResourceImpl;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseResourceImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.preferences.impl.PreferencesURIHandlerImpl;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.Messages;
import org.eclipse.oomph.setup.internal.core.util.SelfProductCatalogURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.UserURIHandlerImpl;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

public final class SetupCoreUtil {
    public static final String OOMPH_NAMESPACE = "org.eclipse.oomph";
    public static final String STATS_URI = "https://download.eclipse.org/stats/oomph";
    public static final ECFURIHandlerImpl.AuthorizationHandler AUTHORIZATION_HANDLER;
    public static Resource.Factory.Registry RESOURCE_FACTORY_REGISTRY;
    public static URIConverter URI_CONVERTER;
    private static final boolean SKIP_STATS;
    private static final URI HTTP_GIT_ECLIPSE_ORG;
    private static final URI HTTPS_GIT_ECLIPSE_ORG;
    private static volatile Map<URI, URI> archiveRedirections;
    private static volatile String archiveExpectedETag;
    private static Resource.Factory MARKET_PLACE_LISTING_RESOURCE_FACTORY;
    private static final Map<URI, WeakReference<byte[]>> ZIPS;

    static {
        RESOURCE_FACTORY_REGISTRY = new ResourceSetImpl().getResourceFactoryRegistry();
        BaseResourceFactoryImpl factory = new BaseResourceFactoryImpl();
        Map extensionToFactoryMap = RESOURCE_FACTORY_REGISTRY.getExtensionToFactoryMap();
        extensionToFactoryMap.put("xmi", factory);
        extensionToFactoryMap.put("setup", factory);
        extensionToFactoryMap.put("targlet", factory);
        extensionToFactoryMap.put("def", factory);
        extensionToFactoryMap.put("ext", factory);
        extensionToFactoryMap.put(null, factory);
        extensionToFactoryMap.put("ecore", new EcoreResourceFactoryImpl());
        URI_CONVERTER = new ResourceSetImpl().getURIConverter();
        SetupCoreUtil.configureURIHandlers(URI_CONVERTER);
        SKIP_STATS = PropertiesUtil.isProperty((String)"oomph.setup.stats.skip");
        HTTP_GIT_ECLIPSE_ORG = URI.createURI((String)"http://git.eclipse.org/");
        HTTPS_GIT_ECLIPSE_ORG = URI.createURI((String)"https://git.eclipse.org/");
        IProvisioningAgent agent = P2Util.getCurrentProvisioningAgent();
        UIServices uiServices = (UIServices)agent.getService(UIServices.SERVICE_NAME);
        ISecurePreferences root = PreferencesUtil.getSecurePreferences();
        ISecurePreferences securePreferences = root.node(OOMPH_NAMESPACE).node("hosts");
        AUTHORIZATION_HANDLER = new ECFURIHandlerImpl.AuthorizationHandlerImpl(uiServices, securePreferences);
        MARKET_PLACE_LISTING_RESOURCE_FACTORY = new BaseResourceFactoryImpl(){

            protected BaseResource basicCreateResource(URI uri) {
                return new BaseResourceImpl(uri){

                    public void load(Map<?, ?> options) throws IOException {
                        Macro macro = SetupFactory.eINSTANCE.createMacro();
                        MarketPlaceListing marketPlaceListing = MarketPlaceListing.getMarketPlaceListing((URI)this.uri, (URIConverter)this.getURIConverter());
                        if (marketPlaceListing != null) {
                            IOException exception = marketPlaceListing.getException();
                            if (exception != null) {
                                this.getErrors().add((Object)new XMIException((Exception)exception));
                            } else {
                                macro.setLabel(marketPlaceListing.getLabel());
                                macro.setName(marketPlaceListing.getListing().lastSegment());
                                macro.setDescription("<a href='" + String.valueOf(marketPlaceListing.getListing()) + "?'>" + marketPlaceListing.getLabel() + "</a>");
                                P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
                                p2Task.setLabel(marketPlaceListing.getLabel());
                                EList parameters = macro.getParameters();
                                List requirements = marketPlaceListing.getRequirements();
                                for (Requirement requirement : requirements) {
                                    if (MarketPlaceListing.isRequired((Requirement)requirement)) continue;
                                    Object name = requirement.getName();
                                    if (((String)name).endsWith(".feature.group")) {
                                        name = ((String)name).substring(0, ((String)name).length() - ".feature.group".length());
                                    }
                                    name = (String)name + ".enabled";
                                    Parameter parameter = SetupFactory.eINSTANCE.createParameter();
                                    parameter.setName((String)name);
                                    parameter.setDescription(NLS.bind((String)Messages.SetupCoreUtil_Parameter_description, (Object)name));
                                    parameter.setDefaultValue(MarketPlaceListing.isSelected((Requirement)requirement) ? "true" : "false");
                                    parameters.add((Object)parameter);
                                    Annotation featureSubstitutionAnnotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/FeatureSubstitution");
                                    featureSubstitutionAnnotation.getDetails().put((Object)P2Package.Literals.REQUIREMENT__OPTIONAL.getName(), (Object)("${" + (String)name + "|not}"));
                                    featureSubstitutionAnnotation.getDetails().put((Object)P2Package.Literals.REQUIREMENT__GREEDY.getName(), (Object)("${" + (String)name + "}"));
                                    requirement.getAnnotations().add((Object)featureSubstitutionAnnotation);
                                }
                                p2Task.getRequirements().addAll((Collection)requirements);
                                URI updateSite = marketPlaceListing.getUpdateSite();
                                if (updateSite != null) {
                                    Repository repository = P2Factory.eINSTANCE.createRepository(marketPlaceListing.getUpdateSite().toString());
                                    p2Task.getRepositories().add((Object)repository);
                                }
                                macro.getSetupTasks().add((Object)p2Task);
                            }
                        }
                        this.getContents().add((Object)macro);
                    }
                };
            }
        };
        ZIPS = Collections.synchronizedMap(new HashMap());
    }

    private SetupCoreUtil() {
    }

    public static String getLabel(Scope scope) {
        if (scope == null) {
            return "";
        }
        String label = scope.getLabel();
        if (StringUtil.isEmpty((String)label)) {
            label = StringUtil.safe((String)scope.getName());
        }
        return label;
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        SetupCoreUtil.configureResourceSet((ResourceSet)resourceSet);
        return resourceSet;
    }

    public static void configureResourceSet(ResourceSet resourceSet) {
        SetupCoreUtil.configureResourceSet(resourceSet, true);
    }

    private static void configureResourceSet(final ResourceSet resourceSet, boolean configureURIMappings) {
        final Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        ResourceFactoryRegistryImpl specializedResourceFactoryRegistry = new ResourceFactoryRegistryImpl(){

            protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
                if (MarketPlaceListing.isMarketPlaceListing((URI)uri)) {
                    return MARKET_PLACE_LISTING_RESOURCE_FACTORY;
                }
                return resourceFactoryRegistry.getFactory(uri, contentTypeIdentifier);
            }

            protected URIConverter getURIConverter() {
                return resourceSet.getURIConverter();
            }

            protected Map<?, ?> getContentDescriptionOptions() {
                Map contentDescriptionOptions = super.getContentDescriptionOptions();
                HashMap result = new HashMap(contentDescriptionOptions);
                result.putAll(resourceSet.getLoadOptions());
                return result;
            }
        };
        specializedResourceFactoryRegistry.getExtensionToFactoryMap().putAll(RESOURCE_FACTORY_REGISTRY.getExtensionToFactoryMap());
        resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)specializedResourceFactoryRegistry);
        URIConverter uriConverter = resourceSet.getURIConverter();
        Map uriMap = uriConverter.getURIMap();
        SetupCoreUtil.configureURIHandlers(uriConverter);
        class ModelResourceSet
        extends ResourceSetImpl {
            private Map<Resource, Resource> redirectedResources = new HashMap<Resource, Resource>();
            private final /* synthetic */ ResourceSet val$resourceSet;

            public ModelResourceSet(ResourceSet resourceSet, Resource.Factory.Registry registry) {
                this.val$resourceSet = resourceSet;
                this.uriConverter = resourceSet.getURIConverter();
                this.packageRegistry = resourceSet.getPackageRegistry();
                this.resourceFactoryRegistry = registry;
                this.loadOptions = resourceSet.getLoadOptions();
            }

            protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
                Resource result = super.delegatedGetResource(uri, loadOnDemand);
                if (result == null) {
                    result = super.delegatedGetResource(this.uriConverter.normalize(uri), loadOnDemand);
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Resource getResource(URI uri, boolean loadOnDemand) {
                try {
                    Resource resource = super.getResource(uri, true);
                    Resource redirectedResource = this.redirectedResources.get(resource);
                    if (redirectedResource != null) {
                        return redirectedResource;
                    }
                    if (resource.getResourceSet() == this) {
                        ResourceSet resourceSet = this.val$resourceSet;
                        synchronized (resourceSet) {
                            this.val$resourceSet.getResources().add((Object)resource);
                        }
                    }
                    return resource;
                }
                catch (RuntimeException throwable) {
                    Resource resource = super.getResource(uri, false);
                    if (resource.getResourceSet() == this) {
                        ResourceSet resourceSet = this.val$resourceSet;
                        synchronized (resourceSet) {
                            this.val$resourceSet.getResources().add((Object)resource);
                        }
                    }
                    if (loadOnDemand) {
                        throw throwable;
                    }
                    return null;
                }
            }

            protected void demandLoad(Resource resource) throws IOException {
                super.demandLoad(resource);
                EPackage ePackage = (EPackage)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE);
                if (ePackage != null) {
                    String nsURI = ePackage.getNsURI();
                    EPackage redirectedEPackage = this.packageRegistry.getEPackage(nsURI);
                    for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                        String instanceClassName = eClassifier.getInstanceClassName();
                        if (instanceClassName == null) continue;
                        if (eClassifier instanceof EDataType) {
                            eClassifier.setInstanceClass(String.class);
                            continue;
                        }
                        eClassifier.setInstanceClassName(null);
                        eClassifier.setInstanceClass(null);
                    }
                    if (redirectedEPackage != null) {
                        this.redirectedResources.put(resource, redirectedEPackage.eResource());
                        this.packageRegistry.put((Object)resource.getURI().toString(), (Object)redirectedEPackage);
                        this.packageRegistry.put((Object)this.uriConverter.normalize(resource.getURI()).toString(), (Object)redirectedEPackage);
                    } else {
                        this.packageRegistry.put((Object)resource.getURI().toString(), (Object)ePackage);
                        this.packageRegistry.put((Object)this.uriConverter.normalize(resource.getURI()).toString(), (Object)ePackage);
                        ((EPackageImpl)ePackage).freeze();
                    }
                }
            }
        }
        final ModelResourceSet modelResourceSet = new ModelResourceSet(resourceSet, (Resource.Factory.Registry)specializedResourceFactoryRegistry);
        new ResourceSetImpl.MappedResourceLocator((ResourceSetImpl)resourceSet){
            {
                super($anonymous0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Resource getResource(URI uri, boolean loadOnDemand) {
                if (BaseUtil.isBogusURI((URI)uri)) {
                    return null;
                }
                if ("ecore".equals(uri.fileExtension())) {
                    Resource resource = null;
                    ResourceSetImpl resourceSetImpl = this.resourceSet;
                    synchronized (resourceSetImpl) {
                        resource = super.getResource(uri, false);
                        if (resource != null) {
                            if (!resource.isLoaded()) {
                                this.demandLoadHelper(resource);
                            }
                            return resource;
                        }
                        resource = modelResourceSet.getResource(uri, loadOnDemand);
                        if (resource != null) {
                            return resource;
                        }
                    }
                }
                return super.getResource(uri, loadOnDemand);
            }
        };
        if (configureURIMappings) {
            uriMap.put(SetupContext.INDEX_ROOT_URI, SetupContext.INDEX_ROOT_LOCATION_URI);
            SetupCoreUtil.configureRedirections(uriMap);
            if (!SetupUtil.SETUP_ARCHIVER_APPLICATION) {
                SetupCoreUtil.handleArchiveRedirection(uriConverter);
            }
        }
    }

    private static void configureURIHandlers(URIConverter uriConverter) {
        EList uriHandlers = uriConverter.getURIHandlers();
        int i = 0;
        int size = uriHandlers.size();
        while (i < size) {
            URIHandler uriHandler = (URIHandler)uriHandlers.get(i);
            if (uriHandler instanceof FileURIHandlerImpl) {
                uriHandlers.set(i, (Object)new FileURIHandlerImpl(){

                    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                        byte[] bytes;
                        if (!"zip".equals(uri.fileExtension()) || Boolean.FALSE.equals(options.get("OPTION_ZIP_CACHE"))) {
                            return super.createInputStream(uri, options);
                        }
                        WeakReference<byte[]> bytesReference = ZIPS.get(uri);
                        if (bytesReference != null && (bytes = (byte[])bytesReference.get()) != null) {
                            return new ByteArrayInputStream(bytes);
                        }
                        InputStream in = super.createInputStream(uri, options);
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        try {
                            IOUtil.copy((InputStream)in, (OutputStream)out);
                            byte[] bytes2 = out.toByteArray();
                            ZIPS.put(uri, new WeakReference<byte[]>(bytes2));
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes2);
                            return byteArrayInputStream;
                        }
                        catch (IORuntimeException ex) {
                            throw (IOException)ex.getCause();
                        }
                        finally {
                            IOUtil.close((Closeable)in);
                        }
                    }
                });
            } else if (uriHandler instanceof ArchiveURIHandlerImpl) {
                uriHandlers.set(i, (Object)new ArchiveURIHandlerImpl(){

                    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
                        byte[] bytes;
                        if (Boolean.FALSE.equals(options.get("OPTION_ZIP_CACHE"))) {
                            return super.createInputStream(uri, options);
                        }
                        WeakReference<byte[]> bytesReference = ZIPS.get(uri);
                        if (bytesReference != null && (bytes = (byte[])bytesReference.get()) != null) {
                            return new ByteArrayInputStream(bytes);
                        }
                        String authority = uri.authority();
                        URI archiveURI = URI.createURI((String)authority.substring(0, authority.length() - 1));
                        URI baseURI = uri.trimSegments(uri.segmentCount());
                        byte[] result = null;
                        InputStream inputStream = this.getURIConverter(options).createInputStream(archiveURI, options);
                        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        while (zipEntry != null) {
                            String name = zipEntry.getName();
                            URI entryURI = URI.createURI((String)name).resolve(baseURI);
                            ByteArrayOutputStream output = new ByteArrayOutputStream();
                            try {
                                IOUtil.copy((InputStream)zipInputStream, (OutputStream)output);
                                byte[] bytes2 = output.toByteArray();
                                ZIPS.put(entryURI, new WeakReference<byte[]>(bytes2));
                                if (entryURI.equals(uri)) {
                                    result = bytes2;
                                }
                            }
                            catch (IORuntimeException ex) {
                                throw (IOException)ex.getCause();
                            }
                            zipEntry = zipInputStream.getNextEntry();
                        }
                        zipInputStream.close();
                        if (result == null) {
                            throw new FileNotFoundException(uri.toString());
                        }
                        return new ByteArrayInputStream(result);
                    }
                });
            }
            ++i;
        }
        int insertionPoint = uriHandlers.size() - 1;
        uriHandlers.add(insertionPoint, (Object)new UserURIHandlerImpl());
        uriHandlers.add(++insertionPoint, (Object)new SelfProductCatalogURIHandlerImpl());
        uriHandlers.add(++insertionPoint, (Object)new PreferencesURIHandlerImpl());
        uriHandlers.add(++insertionPoint, (Object)new ECFURIHandlerImpl(AUTHORIZATION_HANDLER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureRedirections(Map<URI, URI> uriMap) {
        HashMap<Object, Object> safeProperties;
        Properties properties;
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            safeProperties = new HashMap<Object, Object>(properties);
        }
        for (Map.Entry entry : safeProperties.entrySet()) {
            URI sourceURI;
            Object key = entry.getKey();
            if (!(key instanceof String) || !((String)key).startsWith("oomph.redirection.")) continue;
            String[] mapping = ((String)entry.getValue()).split("->");
            if (mapping.length == 1) {
                sourceURI = URI.createURI((String)mapping[0]);
                uriMap.remove(sourceURI);
                continue;
            }
            if (mapping.length != 2) continue;
            sourceURI = URI.createURI((String)mapping[0]);
            URI targetURI = URI.createURI((String)mapping[1].replace("\\", "/"));
            if (targetURI.isFile()) {
                File file;
                if (targetURI.isRelative()) {
                    targetURI = targetURI.resolve(SetupContext.PRODUCT_LOCATION.trimSegments(OS.INSTANCE.isMac() ? 2 : 0).appendSegment(""));
                }
                if (!(file = new File(targetURI.toFileString())).exists()) continue;
            }
            SetupCoreUtil.handlePut(uriMap, sourceURI, targetURI);
        }
    }

    private static void handlePut(Map<URI, URI> redirections, URI source, URI target) {
        redirections.put(source, target);
        URI httpGitEclipseOrgRelativeURI = source.deresolve(HTTP_GIT_ECLIPSE_ORG);
        if (httpGitEclipseOrgRelativeURI != source) {
            redirections.put(httpGitEclipseOrgRelativeURI.resolve(HTTPS_GIT_ECLIPSE_ORG), target);
        } else {
            URI httpsGitEclipseOrgRelativeURI = source.deresolve(HTTPS_GIT_ECLIPSE_ORG);
            if (httpsGitEclipseOrgRelativeURI != source) {
                redirections.put(httpGitEclipseOrgRelativeURI.resolve(HTTP_GIT_ECLIPSE_ORG), target);
            }
        }
    }

    private static void handleArchiveRedirection(URIConverter uriConverter) {
        URI indexSetupArchiveLocation = uriConverter.normalize(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI);
        if (archiveExpectedETag == null || !archiveExpectedETag.equals(ECFURIHandlerImpl.getExpectedETag(indexSetupArchiveLocation))) {
            HashMap<String, ECFURIHandlerImpl.CacheHandling> options = new HashMap<String, ECFURIHandlerImpl.CacheHandling>();
            options.put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
            final HashMap<URI, URI> redirections = new HashMap<URI, URI>();
            ArchiveResourceImpl archiveResource = new ArchiveResourceImpl(SetupContext.INDEX_SETUP_ARCHIVE_LOCATION_URI, uriConverter){

                protected void handle(EMap<String, String> details, URI uri, URI archiveEntry) {
                    SetupCoreUtil.handlePut(redirections, uri, archiveEntry);
                }
            };
            try {
                archiveResource.load(options);
            }
            catch (IOException ex) {
                SetupCorePlugin.INSTANCE.log(ex, 2);
                ECFURIHandlerImpl.setExpectedETag(indexSetupArchiveLocation, "Failed");
            }
            archiveRedirections = redirections;
            archiveExpectedETag = ECFURIHandlerImpl.getExpectedETag(indexSetupArchiveLocation);
        }
        Map uriMap = uriConverter.getURIMap();
        for (Map.Entry<URI, URI> entry : archiveRedirections.entrySet()) {
            URI sourceURI = entry.getKey();
            if (!sourceURI.equals(uriConverter.normalize(sourceURI))) continue;
            URI targetURI = entry.getValue();
            uriMap.put(sourceURI, targetURI);
        }
    }

    public static <T> void reorder(EList<T> values, DependencyProvider<T> dependencyProvider) {
        int i = 0;
        int size = values.size();
        int count = 0;
        while (i < size) {
            Object value = values.get(i);
            if (count == size) {
                SetupCorePlugin.INSTANCE.log(NLS.bind((String)Messages.SetupCoreUtil_CircularDependencies_message, (Object)value), 2);
                return;
            }
            boolean changed = false;
            for (Object dependency : dependencyProvider.getDependencies(value)) {
                int index = values.indexOf(dependency);
                if (index <= i) continue;
                values.move(i, index);
                changed = true;
            }
            if (changed) {
                --i;
                ++count;
            } else {
                count = 0;
            }
            ++i;
        }
    }

    public static void migrate(Resource resource, Collection<EObject> result) {
        new Migrator(resource).migrate(result);
    }

    public static void sendStats(boolean success, Scope scope, OS os) {
        URI statusURI;
        ResourceSet resourceSet;
        if (SKIP_STATS || scope == null) {
            return;
        }
        Resource resource = scope.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null && (statusURI = SetupCoreUtil.getStatsURI(success, scope)) != null) {
            if (os != null) {
                statusURI = statusURI.appendSegment(os.getOsgiOS());
                statusURI = statusURI.appendSegment(os.getOsgiWS());
                statusURI = statusURI.appendSegment(os.getOsgiArch());
            }
            resourceSet.getURIConverter().exists(statusURI, null);
        }
    }

    public static URI getStatsURI(boolean success, Scope scope) {
        String prefix = SetupCoreUtil.getStatsPrefix(scope);
        if (prefix == null) {
            return null;
        }
        URI statusURI = null;
        ArrayList<String> names = new ArrayList<String>();
        Scope x = scope;
        while (x != null) {
            Annotation annotation;
            if (SetupContext.isUserScheme(EcoreUtil.getURI((EObject)x).scheme())) {
                return null;
            }
            if (statusURI == null && (annotation = x.getAnnotation("http://www.eclipse.org/oomph/setup/StatsSending")) != null) {
                String uri = (String)annotation.getDetails().get((Object)"uri");
                if (StringUtil.isEmpty((String)uri)) {
                    return null;
                }
                statusURI = URI.createURI((String)uri);
            }
            names.add(0, URI.encodeSegment((String)x.getName(), (boolean)false));
            x = x.getParentScope();
        }
        if (statusURI != null) {
            statusURI = statusURI.appendSegment(prefix).appendSegment(success ? "success" : "failure");
            for (String name : names) {
                statusURI = statusURI.appendSegment(name);
            }
        }
        return statusURI;
    }

    private static String getStatsPrefix(Scope scope) {
        switch (scope.getType()) {
            case PRODUCT_VERSION: {
                return "product";
            }
            case STREAM: {
                return "project";
            }
        }
        return null;
    }

    public static URI getEclipseBrandingImage() {
        return URI.createPlatformPluginURI((String)"org.eclipse.oomph.setup.ui/icons/committers.png", (boolean)true);
    }

    public static URI getBrandingImageURI(Scope scope) {
        URI imageURI = null;
        if (scope != null && (imageURI = SetupCoreUtil.internalGetBrandingImageURI((ModelElement)scope)) == null) {
            Scope parentScope = scope.getParentScope();
            if (parentScope == null) {
                EObject eContainer = scope.eContainer();
                if (eContainer instanceof Configuration) {
                    imageURI = SetupCoreUtil.internalGetBrandingImageURI((ModelElement)eContainer);
                }
            } else {
                imageURI = SetupCoreUtil.getBrandingImageURI(parentScope);
            }
        }
        if (imageURI == null) {
            imageURI = SetupCoreUtil.getEclipseBrandingImage();
        }
        return imageURI;
    }

    private static URI internalGetBrandingImageURI(ModelElement modelElement) {
        String detail;
        Annotation annotation = modelElement.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation != null && (detail = (String)annotation.getDetails().get((Object)"imageURI")) != null) {
            return URI.createURI((String)detail);
        }
        return null;
    }

    public static interface DependencyProvider<T> {
        public Collection<? extends T> getDependencies(T var1);
    }

    public static class Migrator {
        private Resource resource;

        public Migrator(Resource resource) {
            this.resource = resource;
        }

        public Collection<? extends EObject> migrate(Collection<EObject> result) {
            RuntimeException runtimeException;
            MigrationCopier migrationCopier;
            block14: {
                migrationCopier = new MigrationCopier(this.resource.getResourceSet().getPackageRegistry());
                HashSet<EObject> allContainedObjects = new HashSet<EObject>();
                HashSet<EObject> allCrossReferencedObjects = new HashSet<EObject>();
                TreeIterator it = this.resource.getAllContents();
                while (it.hasNext()) {
                    EObject containedEObject = (EObject)it.next();
                    allContainedObjects.add(containedEObject);
                    for (Object eObject : containedEObject.eCrossReferences()) {
                        allCrossReferencedObjects.add((EObject)eObject);
                        if (!eObject.eIsProxy()) continue;
                        migrationCopier.copy((EObject)eObject);
                    }
                }
                allCrossReferencedObjects.removeAll(allContainedObjects);
                for (EObject eObject : allCrossReferencedObjects) {
                    migrationCopier.copyAsProxy(eObject);
                }
                runtimeException = null;
                try {
                    migrationCopier.copyAll((Collection)this.resource.getContents());
                }
                catch (RuntimeException ex) {
                    runtimeException = ex;
                }
                try {
                    migrationCopier.copyReferences();
                }
                catch (RuntimeException ex) {
                    if (runtimeException != null) break block14;
                    runtimeException = ex;
                }
            }
            for (EObject eObject : this.resource.getContents()) {
                EObject copiedEObject = (EObject)migrationCopier.get(eObject);
                if (copiedEObject == null) continue;
                result.add(copiedEObject);
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
            LinkedHashSet<ModelElement> annotatedModelElements = new LinkedHashSet<ModelElement>();
            TreeIterator it = EcoreUtil.getAllContents(result);
            while (it.hasNext()) {
                Annotation annotation;
                Object object = it.next();
                if (!(object instanceof Annotation) || !"http://www.eclipse.org/oomph/Migrator".equals((annotation = (Annotation)object).getSource())) continue;
                annotatedModelElements.add(annotation.getModelElement());
            }
            for (ModelElement modelElement : annotatedModelElements) {
                try {
                    ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(modelElement.getClass(), (String)"eMigrate", (Class[])new Class[0]), (Object)modelElement, (Object[])new Object[0]);
                }
                catch (ReflectUtil.ReflectionException annotation) {
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return result;
        }

        private static class MigrationCopier
        extends EcoreUtil.Copier {
            private static final long serialVersionUID = 1L;
            private EPackage.Registry packageRegistry;

            public MigrationCopier(EPackage.Registry packageRegistry) {
                this.packageRegistry = packageRegistry;
            }

            public EObject copyAsProxy(EObject eObject) {
                EObject copiedEObject = this.createCopy(eObject);
                if (copiedEObject != null) {
                    this.put(eObject, copiedEObject);
                    ((InternalEObject)copiedEObject).eSetProxyURI(URI.createURI((String)("bogus:/" + String.valueOf(BaseUtil.getRootURI((EObject)eObject)))));
                }
                return copiedEObject;
            }

            protected EClass getTarget(EClass eClass) {
                return this.getEClass((ENamedElement)eClass, "name", "nsURI");
            }

            protected EClass getEClass(ENamedElement eNamedElement, String nameAnnotation, String nsURIAnnotation) {
                String nsURIs = this.getAnnotation((EModelElement)eNamedElement, nsURIAnnotation);
                if (nsURIs == null) {
                    EObject eContainer = eNamedElement.eContainer();
                    while (eContainer != null) {
                        if (eContainer instanceof EPackage) {
                            nsURIs = this.getAnnotation((EModelElement)((EPackage)eContainer), "nsURIs");
                        }
                        eContainer = eContainer.eContainer();
                    }
                }
                if (nsURIs == null) {
                    throw new IllegalStateException(NLS.bind((String)Messages.SetupCoreUtil_MissingPackage_exception, (Object)EcoreUtil.getURI((EObject)eNamedElement)));
                }
                String name = this.getAnnotation((EModelElement)eNamedElement, nameAnnotation);
                if (name == null) {
                    name = eNamedElement.getName();
                }
                String[] stringArray = nsURIs.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EClassifier eClassifier;
                    String nsURI = stringArray[n2];
                    EPackage ePackage = this.packageRegistry.getEPackage(nsURI);
                    if (ePackage != null && (eClassifier = ePackage.getEClassifier(name)) instanceof EClass) {
                        return (EClass)eClassifier;
                    }
                    ++n2;
                }
                throw new IllegalStateException(NLS.bind((String)Messages.SetupCoreUtil_MissingClass_exception, (Object)name, (Object)EcoreUtil.getURI((EObject)eNamedElement)));
            }

            protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
                EStructuralFeature result;
                String name = this.getAnnotation((EModelElement)eStructuralFeature, "name");
                if (name == null) {
                    name = eStructuralFeature.getName();
                }
                if ((result = this.getTarget(eStructuralFeature.getEContainingClass()).getEStructuralFeature(name)) != null) {
                    return result;
                }
                throw new IllegalStateException(NLS.bind((String)Messages.SetupCoreUtil_MissingFeature_exception, (Object)EcoreUtil.getURI((EObject)eStructuralFeature)));
            }

            protected EStructuralFeature.Setting getTarget(EStructuralFeature eStructuralFeature, EObject eObject, EObject copyEObject) {
                EStructuralFeature.Setting setting;
                String targetName;
                String name = this.getAnnotation((EModelElement)eStructuralFeature, "name");
                if ("".equals(name)) {
                    return null;
                }
                if (name == null) {
                    name = eStructuralFeature.getName();
                }
                if ((targetName = this.getAnnotation((EModelElement)eStructuralFeature, "targetName")) != null) {
                    EClass targetEClass = this.getEClass((ENamedElement)eStructuralFeature, "targetName", "targetNsURI");
                    EClass eClass = copyEObject.eClass();
                    for (EReference eReference : eClass.getEAllContainments()) {
                        EClass eReferenceType = eReference.getEReferenceType();
                        if (eReferenceType != targetEClass) continue;
                        EStructuralFeature.Setting setting2 = this.demandCreateContainer(copyEObject, targetEClass, eReferenceType, name, eStructuralFeature, eReference);
                        if (setting2 != null && targetEClass == BasePackage.Literals.ANNOTATION) {
                            Annotation annotation = (Annotation)setting2.getEObject();
                            annotation.setSource("http://www.eclipse.org/oomph/Migrator");
                            Map.Entry stringToStringMapEntry = (Map.Entry)BaseFactory.eINSTANCE.create(BasePackage.Literals.STRING_TO_STRING_MAP_ENTRY);
                            InternalEObject mapEntry = (InternalEObject)stringToStringMapEntry;
                            mapEntry.eSet((EStructuralFeature)BasePackage.Literals.STRING_TO_STRING_MAP_ENTRY__KEY, (Object)EcoreUtil.getURI((EObject)eStructuralFeature).toString());
                            annotation.getDetails().add((Object)stringToStringMapEntry);
                            return mapEntry.eSetting((EStructuralFeature)BasePackage.Literals.STRING_TO_STRING_MAP_ENTRY__VALUE);
                        }
                        return setting2;
                    }
                }
                if ((setting = this.demandCreateContainer(copyEObject, name, eStructuralFeature)) != null) {
                    return setting;
                }
                throw new IllegalStateException(NLS.bind((String)Messages.SetupCoreUtil_MissingFeature_exception, (Object)EcoreUtil.getURI((EObject)eStructuralFeature)));
            }

            protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                EStructuralFeature.Setting setting;
                EClass targetEClass;
                String targetName = this.getAnnotation((EModelElement)eAttribute, "targetName");
                if (targetName != null && (targetEClass = this.getEClass((ENamedElement)eAttribute, "targetName", "targetNsURI")) == BasePackage.Literals.ANNOTATION && (setting = this.getTarget((EStructuralFeature)eAttribute, eObject, copyEObject)) != null) {
                    this.copyAttributeValue(eAttribute, eObject, eObject.eGet((EStructuralFeature)eAttribute), setting);
                    return;
                }
                super.copyAttribute(eAttribute, eObject, copyEObject);
            }

            protected EStructuralFeature.Setting demandCreateContainer(EObject copyEObject, String name, EStructuralFeature eStructuralFeature) {
                return this.demandCreateContainer(new HashSet<EClass>(), copyEObject, name, eStructuralFeature);
            }

            protected EStructuralFeature.Setting demandCreateContainer(Set<EClass> tried, final EObject copyEObject, String name, EStructuralFeature eStructuralFeature) {
                EClass targetEClass = copyEObject.eClass();
                if (!tried.add(targetEClass)) {
                    return null;
                }
                EStructuralFeature targetEStructuralFeature = targetEClass.getEStructuralFeature(name);
                if (targetEStructuralFeature != null) {
                    EClass expectedTargetEClass;
                    EClass actualTargetEClass;
                    if (targetEStructuralFeature instanceof EReference && eStructuralFeature instanceof EReference && (actualTargetEClass = ((EReference)targetEStructuralFeature).getEReferenceType()) != (expectedTargetEClass = this.getTarget(((EReference)eStructuralFeature).getEReferenceType()))) {
                        for (EReference eReference : targetEClass.getEAllContainments()) {
                            EClass eReferenceType = eReference.getEReferenceType();
                            if (!eReferenceType.isSuperTypeOf(actualTargetEClass)) continue;
                            for (EReference childEReference : eReferenceType.getEAllContainments()) {
                                if (!childEReference.getEReferenceType().isSuperTypeOf(expectedTargetEClass)) continue;
                                return this.demandCreateContainer(copyEObject, actualTargetEClass, eReference, (EStructuralFeature)childEReference, true);
                            }
                        }
                        throw new IllegalStateException(NLS.bind((String)Messages.SetupCoreUtil_MissingMatchingFeature_exception, (Object)EcoreUtil.getURI((EObject)eStructuralFeature)));
                    }
                    return ((InternalEObject)copyEObject).eSetting(targetEStructuralFeature);
                }
                EClass targetEContainingClass = this.getTarget(eStructuralFeature.getEContainingClass());
                if (targetEContainingClass != null) {
                    for (final EReference eReference : targetEClass.getEAllContainments()) {
                        EStructuralFeature.Setting setting;
                        EClass eReferenceType = eReference.getEReferenceType();
                        if (!targetEContainingClass.isSuperTypeOf(eReferenceType) || (setting = this.demandCreateContainer(copyEObject, targetEContainingClass, eReferenceType, name, eStructuralFeature, eReference)) == null) continue;
                        return setting;
                    }
                    for (final EReference eReference : targetEClass.getEAllContainments()) {
                        EObject targetContainer;
                        EClass eReferenceEType = eReference.getEReferenceType();
                        if (eReferenceEType.isAbstract()) continue;
                        Runnable addToContainer = null;
                        Object targetValue = copyEObject.eGet((EStructuralFeature)eReference);
                        if (eReference.isMany()) {
                            final List targetValues = (List)targetValue;
                            if (targetValues.isEmpty()) {
                                EObject demandCreatedTargetContainer;
                                targetContainer = demandCreatedTargetContainer = EcoreUtil.create((EClass)eReferenceEType);
                                addToContainer = new Runnable(){

                                    @Override
                                    public void run() {
                                        targetValues.add(demandCreatedTargetContainer);
                                    }
                                };
                            } else {
                                targetContainer = (EObject)targetValues.get(0);
                            }
                        } else if (targetValue == null) {
                            EObject demandCreatedTargetContainer;
                            targetContainer = demandCreatedTargetContainer = EcoreUtil.create((EClass)eReferenceEType);
                            addToContainer = new Runnable(){

                                @Override
                                public void run() {
                                    copyEObject.eSet((EStructuralFeature)eReference, (Object)demandCreatedTargetContainer);
                                }
                            };
                        } else {
                            targetContainer = (EObject)targetValue;
                        }
                        EStructuralFeature.Setting setting = this.demandCreateContainer(tried, targetContainer, name, eStructuralFeature);
                        if (setting == null) continue;
                        if (addToContainer != null) {
                            addToContainer.run();
                        }
                        return setting;
                    }
                }
                return null;
            }

            protected EStructuralFeature.Setting demandCreateContainer(EObject copyEObject, EClass targetEClass, EClass eReferenceType, String name, EStructuralFeature eStructuralFeature, EReference eReference) {
                if (targetEClass.isSuperTypeOf(eReferenceType)) {
                    EStructuralFeature targetEStructuralFeature = targetEClass.getEStructuralFeature(name);
                    if (targetEStructuralFeature == null) {
                        throw new IllegalStateException(NLS.bind((String)Messages.SetupCoreUtil_MisssingFeature_exception, (Object)EcoreUtil.getURI((EObject)eStructuralFeature)));
                    }
                    return this.demandCreateContainer(copyEObject, eReferenceType, eReference, targetEStructuralFeature, false);
                }
                return null;
            }

            private EStructuralFeature.Setting demandCreateContainer(EObject copyEObject, EClass eReferenceType, EReference eReference, EStructuralFeature settingFeature, boolean additional) {
                EObject targetContainer;
                Object targetValue = copyEObject.eGet((EStructuralFeature)eReference);
                if (eReference.isMany()) {
                    List targetValues = (List)targetValue;
                    if (additional || targetValues.isEmpty()) {
                        targetContainer = EcoreUtil.create((EClass)eReferenceType);
                        targetValues.add(targetContainer);
                    } else {
                        targetContainer = (EObject)targetValues.get(0);
                    }
                } else if (additional || targetValue == null) {
                    targetContainer = EcoreUtil.create((EClass)eReferenceType);
                    copyEObject.eSet((EStructuralFeature)eReference, (Object)targetContainer);
                } else {
                    targetContainer = (EObject)targetValue;
                }
                return ((InternalEObject)targetContainer).eSetting(settingFeature);
            }

            protected void copyAttributeValue(EAttribute eAttribute, EObject eObject, Object value, EStructuralFeature.Setting setting) {
                EDataType eDataType = eAttribute.getEAttributeType();
                EDataType targetEDataType = (EDataType)setting.getEStructuralFeature().getEType();
                if (eDataType.getInstanceClass() != targetEDataType.getInstanceClass() || eDataType.getInstanceClass() == null) {
                    if (eAttribute.isMany()) {
                        List values = (List)value;
                        List transformedValues = (List)setting.get(false);
                        for (Object object : values) {
                            transformedValues.add(this.convert(eDataType, targetEDataType, object));
                        }
                    } else {
                        setting.set(this.convert(eDataType, targetEDataType, value));
                    }
                } else {
                    super.copyAttributeValue(eAttribute, eObject, value, setting);
                }
            }

            protected Object convert(EDataType sourceEDataType, EDataType targetEDataType, Object sourceValue) {
                return EcoreUtil.createFromString((EDataType)targetEDataType, (String)EcoreUtil.convertToString((EDataType)sourceEDataType, (Object)sourceValue));
            }

            private String getAnnotation(EModelElement eModelElement, String key) {
                return EcoreUtil.getAnnotation((EModelElement)eModelElement, (String)"http://www.eclipse.org/oomph/Migrator", (String)key);
            }
        }
    }
}

