/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor.event;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.ai.internal.ui.scripteditor.ScriptEditorTimerUtil;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.PlayerControlEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.PlayerControlEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEventListener;

public class EventManager {
    private static EventManager ownInst = null;
    private static List<SyncTimeEventListener> SyncListeners = new ArrayList<SyncTimeEventListener>();
    private static List<MouseDragEventListener> DragListeners = new ArrayList<MouseDragEventListener>();
    private static List<PlayerControlEventListener> PlayerControlEventListeners = new ArrayList<PlayerControlEventListener>();
    private static List<TimerEventListener> TimerEventListeners = new ArrayList<TimerEventListener>();

    public static EventManager getInstance() {
        if (ownInst == null) {
            ownInst = new EventManager();
        }
        return ownInst;
    }

    private EventManager() {
        ScriptEditorTimerUtil.getInstance();
    }

    public synchronized void addSyncTimeEventListener(SyncTimeEventListener listener) {
        SyncListeners.add(listener);
    }

    public synchronized void removeSyncTimeEventListener(SyncTimeEventListener listener) {
        SyncListeners.remove(listener);
    }

    public synchronized void fireSyncTimeEvent(SyncTimeEvent event) {
        for (SyncTimeEventListener listener : SyncListeners) {
            listener.handleSyncTimeEvent(event);
        }
    }

    public synchronized void addMouseDragEventListener(MouseDragEventListener listener) {
        DragListeners.add(listener);
    }

    public synchronized void removeMouseDragEventListener(MouseDragEventListener listener) {
        DragListeners.remove(listener);
    }

    public synchronized void fireMouseDragEvent(MouseDragEvent event) {
        for (MouseDragEventListener listener : DragListeners) {
            listener.handleMouseDragEvent(event);
        }
    }

    public synchronized void addPlayerControlEvenListener(PlayerControlEventListener listener) {
        PlayerControlEventListeners.add(listener);
    }

    public synchronized void removePlayerControlEventListener(PlayerControlEventListener listener) {
        PlayerControlEventListeners.remove(listener);
    }

    public synchronized void firePlayerControlEvent(PlayerControlEvent event) {
        for (PlayerControlEventListener listener : PlayerControlEventListeners) {
            listener.handlePlayPauseEvent(event);
        }
    }

    public synchronized void addTimerEventListener(TimerEventListener listener) {
        TimerEventListeners.add(listener);
    }

    public synchronized void removeTimerEventListener(TimerEventListener listener) {
        TimerEventListeners.remove(listener);
    }

    public synchronized void fireTimerEvent(TimerEvent event) {
        for (TimerEventListener listener : TimerEventListeners) {
            listener.handleTimerUtilEvent(event);
        }
    }
}

