/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;

public abstract class CompositeModelGroup
implements IModelGroup {
    protected IModelGroup[] children = new IModelGroup[128];
    protected int childLength;
    private boolean[] hash = null;

    public void refer(boolean infinite) {
        int i = 0;
        while (i < this.childLength) {
            this.children[i].refer(infinite);
            ++i;
        }
    }

    protected CompositeModelGroup(IModelGroup modelGroup) {
        this.children[0] = modelGroup;
        this.childLength = 1;
        modelGroup.refer(false);
    }

    public boolean match(int number) {
        return this.hash[number];
    }

    public boolean[] rehash(int totalSize) {
        if (this.hash != null) {
            return this.hash;
        }
        this.hash = new boolean[totalSize];
        int i = this.childLength - 1;
        while (i >= 0) {
            boolean[] childHash = this.children[i].rehash(totalSize);
            if (childHash != null) {
                int j = totalSize - 1;
                while (j >= 0) {
                    int n = j;
                    this.hash[n] = this.hash[n] | childHash[j];
                    --j;
                }
            }
            --i;
        }
        return this.hash;
    }

    public int getChildLength() {
        return this.childLength;
    }
}

