/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.DTDParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityDeclaration;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLEntityReference;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.UnsynchronizedHashtable;

public class SGMLDocTypeDef {
    private static Hashtable<String, SGMLDocTypeDef> table = new Hashtable();
    private SGMLParser parser;
    protected UnsynchronizedHashtable elementDefs = new UnsynchronizedHashtable();
    private Hashtable<String, SGMLEntityReference> entityRefs = new Hashtable();
    private Hashtable<String, SGMLEntityDeclaration> entityDecls = new Hashtable();
    private String id;
    private int elementNum;
    int maxSeqLength = 0;

    protected SGMLDocTypeDef(SGMLParser parser, String id) {
        this.parser = parser;
        this.id = id;
    }

    static SGMLDocTypeDef createAnonymous(SGMLParser parser) {
        return new SGMLDocTypeDef(parser, "anonymous");
    }

    public ElementDefinition createElementDefinition(String name) {
        ElementDefinition ret = this.elementDefs.get(name = name.toUpperCase());
        if (ret == null) {
            ret = new ElementDefinition(name);
            this.elementDefs.put(name, ret);
        }
        return ret;
    }

    public static SGMLDocTypeDef createPublic(String publicID, SGMLParser parser) {
        return new SGMLDocTypeDef(parser, publicID);
    }

    static void putPublic(String publicID, SGMLDocTypeDef dtd) {
        table.put(publicID, dtd);
    }

    public ElementDefinition getElementDefinition(String name) {
        return this.elementDefs.get(name);
    }

    public ElementDefinition getElementDefinition(int num) {
        try {
            return this.elementDefs.get(num);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    SGMLEntityDeclaration getEntityDeclaration(String entityName) {
        return this.entityDecls.get(entityName);
    }

    SGMLEntityReference getEntityReference(String name) throws ParseException {
        SGMLEntityReference ret = this.entityRefs.get(name);
        if (ret == null) {
            SGMLEntityDeclaration ed = this.getEntityDeclaration(name);
            if (ed == null) {
                throw new DTDParseException("No Entity Definition: " + name);
            }
            ret = new SGMLEntityReference(name, ed);
            this.entityRefs.put(name, ret);
        }
        return ret;
    }

    public static SGMLDocTypeDef getPublic(String publicID) {
        return table.get(publicID);
    }

    void putEntityDeclaration(String entityName, String entityString) {
        if (this.entityDecls.get(entityName) != null) {
            return;
        }
        SGMLEntityDeclaration dec = new SGMLEntityDeclaration(entityName, entityString, this);
        this.entityDecls.put(entityName, dec);
    }

    void putPublicEntity(String entityName, String entityString, String filename) {
        if (this.entityDecls.get(entityName) != null) {
            return;
        }
        class PUBLICEntity
        extends SGMLEntityDeclaration {
            String filename;

            Reader getReplacementReader() throws IOException {
                return SGMLDocTypeDef.this.parser.getResource(this.filename);
            }

            PUBLICEntity(String entityName, String entityString, String filename, SGMLDocTypeDef dtd) {
                super(entityName, entityString, dtd);
                this.filename = filename;
            }
        }
        this.entityDecls.put(entityName, new PUBLICEntity(entityName, entityString, filename, this));
    }

    public String toString() {
        return this.id;
    }

    public boolean singleton(String tagName) {
        ElementDefinition ed = this.getElementDefinition(tagName);
        return ed != null && ed.isSingleton();
    }

    public int getElementCount() {
        return this.elementNum;
    }

    void rehash() {
        this.elementNum = this.elementDefs.size();
        int size = this.elementNum + 2;
        int i = this.elementNum - 1;
        while (i >= 0) {
            this.elementDefs.get(i).rehash(size);
            --i;
        }
    }
}

