/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.comclutch.impl;

import java.util.HashMap;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IResource;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.eclipse.actf.util.win32.comclutch.ResourceManager;
import org.eclipse.actf.util.win32.comclutch.impl.IUnknownImpl;

public class IDispatchImpl
extends IUnknownImpl
implements IDispatch {
    private static final String IS_NOT_AVAILABLE = " is not available.";
    private static final int LCID_SYSTEM_DEFAULT = 1024;
    private static final int DISPATCH_METHOD = 1;
    private static final int DISPATCH_PROPERTYGET = 2;
    private HashMap<String, Long> nameCache;

    private long getDispID(String name) {
        if (this.nameCache == null) {
            this.nameCache = new HashMap(4);
        } else {
            Long ll = this.nameCache.get(name);
            if (ll != null) {
                return ll;
            }
        }
        long[] idl = this._getIDsOfNames(this.getPtr(), new String[]{name}, 1024);
        if (idl == null) {
            return -1L;
        }
        long dispid = idl[0];
        this.nameCache.put(name.intern(), dispid);
        return dispid;
    }

    public void cacheDispIDs(String[] names) {
        if (this.nameCache == null) {
            this.nameCache = new HashMap(names.length);
        }
        long[] idl = this._getIDsOfNames(this.getPtr(), names, 1024);
        int i = 0;
        while (i < idl.length) {
            this.nameCache.put(names[i].intern(), idl[i]);
            ++i;
        }
    }

    public Object invoke(String method, Object[] args) {
        long id = this.getDispID(method);
        if (id == -1L) {
            throw new DispatchException(String.valueOf(method) + IS_NOT_AVAILABLE);
        }
        return this.invoke(id, args);
    }

    public Object invoke(long id, Object[] args) {
        Object obj = this._invoke(this.getPtr(), id, 1024, 1, args);
        return obj;
    }

    public Object invoke0(String method) {
        long id = this.getDispID(method);
        if (id == -1L) {
            throw new DispatchException(String.valueOf(method) + IS_NOT_AVAILABLE);
        }
        return this.invoke0(id);
    }

    public Object invoke0(long id) {
        return this.invoke(id, null);
    }

    public Object invoke1(String method, Object arg1) {
        long id = this.getDispID(method);
        if (id == -1L) {
            throw new DispatchException(String.valueOf(method) + IS_NOT_AVAILABLE);
        }
        return this.invoke1(id, arg1);
    }

    public Object invoke1(long id, Object arg1) {
        return this.invoke(id, new Object[]{arg1});
    }

    public Object get(String prop) {
        long id = this.getDispID(prop);
        if (id == -1L) {
            return null;
        }
        return this.get(id);
    }

    public Object get(long id) {
        Object obj = this._invoke(this.getPtr(), id, 1024, 2, null);
        return obj;
    }

    public Object get(String prop, Object[] args) {
        long id = this.getDispID(prop);
        if (id == -1L) {
            return null;
        }
        return this.get(id, args);
    }

    public Object get(long id, Object[] args) {
        Object obj = this._invoke(this.getPtr(), id, 1024, 2, args);
        return obj;
    }

    public void put(String prop, Object val) {
        long id = this.getDispID(prop);
        if (id == -1L) {
            throw new DispatchException(String.valueOf(prop) + IS_NOT_AVAILABLE);
        }
        this.put(id, val);
    }

    public void put(long id, Object val) {
        this._put(this.getPtr(), id, 1024, val);
    }

    public IDispatchImpl(ResourceManager rm, long ptr, boolean permanent) {
        super(rm, ptr, permanent);
    }

    public IDispatchImpl(ResourceManager rm, IUnknown base) {
        super(rm, base);
    }

    public IDispatchImpl(IUnknownImpl base) {
        super(base);
    }

    private native long[] _getIDsOfNames(long var1, String[] var3, int var4);

    private native Object _invoke(long var1, long var3, int var5, int var6, Object[] var7);

    private native void _put(long var1, long var3, int var5, Object var6);

    public static IDispatch newIDispatch(ResourceManager rm, long ptr, boolean permanent) {
        IDispatchImpl idisp = new IDispatchImpl(rm, ptr, permanent);
        rm.addResource(idisp);
        return idisp;
    }

    public IDispatch newIDispatch(long ptr) {
        IResource r = this.findInResource(ptr);
        if (r != null) {
            IDispatch x = (IDispatch)r;
            return x;
        }
        IDispatchImpl idisp = new IDispatchImpl(this.getResourceManager(), ptr, false);
        this.addResource(idisp);
        return idisp;
    }
}

