/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.sapi.preferences;

import java.util.ArrayList;
import org.eclipse.actf.ai.tts.TTSRegistry;
import org.eclipse.actf.ai.tts.sapi.SAPIPlugin;
import org.eclipse.actf.ai.tts.sapi.engine.SapiVoice;
import org.eclipse.actf.ai.tts.sapi.engine.SpObjectToken;
import org.eclipse.actf.ai.tts.sapi.engine.SpeechObjectTokens;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.ole.win32.Variant;
import org.osgi.framework.Bundle;

public class SapiTestManager {
    private static SapiTestManager instance;
    private SapiVoice sapiVoice = (SapiVoice)TTSRegistry.createTTSEngine((String)"org.eclipse.actf.ai.tts.sapi.engine.SapiVoice");
    private String[][] voiceNames;
    private String[][] audioOutputNames;
    private static final String SAMPLE_TEXT = "Hello. This is test.";

    public SapiTestManager() {
        Variant varAudioOutputs;
        SpObjectToken token;
        int i;
        int count;
        Variant varVoices = this.sapiVoice.getVoices(null, null);
        if (varVoices != null) {
            SpeechObjectTokens voiceTokens = SpeechObjectTokens.getTokens(varVoices);
            if (voiceTokens != null) {
                String exclude = Platform.getResourceString((Bundle)SAPIPlugin.getDefault().getBundle(), (String)"%voice.exclude");
                ArrayList<String[]> voiceList = new ArrayList<String[]>();
                count = voiceTokens.getCount();
                i = 0;
                while (i < count) {
                    Variant varVoice = voiceTokens.getItem(i);
                    if (varVoice != null && (token = SpObjectToken.getToken(varVoice)) != null) {
                        String voiceName = token.getDescription(0);
                        if (exclude == null || !exclude.equals(voiceName)) {
                            voiceList.add(new String[]{voiceName, voiceName});
                        }
                    }
                    ++i;
                }
                this.voiceNames = (String[][])voiceList.toArray((T[])new String[voiceList.size()][]);
            }
            varVoices.dispose();
        }
        if ((varAudioOutputs = this.sapiVoice.getAudioOutputs(null, null)) != null) {
            SpeechObjectTokens audioOutputTokens = SpeechObjectTokens.getTokens(varAudioOutputs);
            if (audioOutputTokens != null) {
                ArrayList<String[]> audioOutputList = new ArrayList<String[]>();
                count = audioOutputTokens.getCount();
                i = 0;
                while (i < count) {
                    Variant varAudioOutput = audioOutputTokens.getItem(i);
                    if (varAudioOutput != null && (token = SpObjectToken.getToken(varAudioOutput)) != null) {
                        String audioOutputName = token.getDescription(0);
                        audioOutputList.add(new String[]{audioOutputName, audioOutputName});
                    }
                    ++i;
                }
                this.audioOutputNames = (String[][])audioOutputList.toArray((T[])new String[audioOutputList.size()][]);
            }
            varAudioOutputs.dispose();
        }
    }

    public static SapiTestManager getInstance() {
        if (instance == null) {
            instance = new SapiTestManager();
        }
        return instance;
    }

    public String[][] getVoiceNames() {
        return this.voiceNames;
    }

    public String getVoiceName(int index) {
        if (this.voiceNames != null && index < this.voiceNames.length) {
            return this.voiceNames[index][1];
        }
        return null;
    }

    public String[][] getAudioOutputNames() {
        return this.audioOutputNames;
    }

    public String getAudioOutputName(int index) {
        if (this.audioOutputNames != null && index < this.audioOutputNames.length) {
            return this.audioOutputNames[index][1];
        }
        return null;
    }

    public void speakTest() {
        this.sapiVoice.speak(SAMPLE_TEXT, 0);
    }
}

