/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.Helper;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.MediaObjectImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

class WMPNodeImpl
extends MediaObjectImpl {
    private final IDispatch controls;
    private final IDispatch settings;

    WMPNodeImpl(NodeImpl baseNode, IDispatch idisp, IDispatch controls) {
        super(baseNode, idisp);
        this.controls = controls;
        Object o = Helper.get(idisp, "settings");
        this.settings = o instanceof IDispatch ? (IDispatch)o : null;
    }

    private boolean execControls(String cmd) {
        try {
            this.controls.invoke0(cmd);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private boolean putSettings(String prop, Object val) {
        if (this.settings == null) {
            return false;
        }
        try {
            this.settings.put(prop, val);
            return true;
        }
        catch (DispatchException dispatchException) {
            return false;
        }
    }

    private Object getSettings(String prop) {
        if (this.settings == null) {
            return null;
        }
        return Helper.get(this.settings, prop);
    }

    public boolean fastForward() {
        return this.execControls("fastForward");
    }

    public boolean fastReverse() {
        return this.execControls("fastReverse");
    }

    public double getCurrentPosition() {
        Object o = Helper.get(this.controls, "currentPosition");
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return 0.0;
    }

    public boolean setCurrentPosition(double pos) {
        Object o = Helper.get(this.inode, "currentPosition");
        if (o instanceof Double) {
            return this.putSettings("currentPosition", new Double(pos));
        }
        if (o instanceof Float) {
            return this.putSettings("currentPosition", new Float((float)pos));
        }
        if (o instanceof Integer) {
            return this.putSettings("currentPosition", new Integer((int)pos));
        }
        return false;
    }

    public double getTotalLength() {
        Object o = Helper.get(this.inode, "Duration");
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        return 0.0;
    }

    public boolean nextTrack() {
        return this.execControls("next");
    }

    public boolean pauseMedia() {
        return this.execControls("pause");
    }

    public boolean playMedia() {
        return this.execControls("play");
    }

    public boolean previousTrack() {
        return this.execControls("previous");
    }

    public boolean stopMedia() {
        return this.execControls("stop");
    }

    public int getVolume() {
        Object o = this.getSettings("volume");
        if (!(o instanceof Integer)) {
            return -1;
        }
        int vol = (Integer)o;
        return vol * 10 + 0;
    }

    public boolean muteMedia(boolean flag) {
        return this.putSettings("mute", flag);
    }

    public boolean setVolume(int val) {
        val = (val - 0) * 100 / 1000;
        return this.putSettings("volume", val);
    }

    public INodeExVideo.VideoState getCurrentState() {
        Object o = Helper.get(this.inode, "playState");
        if (o instanceof Integer) {
            int wmpst = (Integer)o;
            switch (wmpst) {
                case 0: {
                    return INodeExVideo.VideoState.STATE_UNKNOWN;
                }
                case 1: {
                    return INodeExVideo.VideoState.STATE_STOP;
                }
                case 2: {
                    return INodeExVideo.VideoState.STATE_PAUSE;
                }
                case 3: {
                    return INodeExVideo.VideoState.STATE_PLAY;
                }
                case 4: {
                    return INodeExVideo.VideoState.STATE_FASTFORWARD;
                }
                case 5: {
                    return INodeExVideo.VideoState.STATE_FASTREVERSE;
                }
                case 6: 
                case 7: {
                    return INodeExVideo.VideoState.STATE_WAITING;
                }
            }
            return INodeExVideo.VideoState.STATE_STOP;
        }
        return INodeExVideo.VideoState.STATE_UNKNOWN;
    }

    public boolean getMuteState() {
        Object o = this.getSettings("mute");
        if (!(o instanceof Boolean)) {
            return false;
        }
        return (Boolean)o;
    }

    public String getVideoURL() {
        Object url = Helper.get(this.inode, "FileName");
        if (url instanceof String) {
            return (String)url;
        }
        return null;
    }
}

