/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

public class HTTPResponseInMemoryMessage
extends HTTPResponseMessage
implements IHTTPResponseMessage {
    private final byte[] version;
    private final byte[] statusCode;
    private final byte[] reasonPhrase;

    protected HTTPResponseInMemoryMessage(long serial, byte[] version, byte[] statusCode, byte[] reasonPhrase) {
        super(serial);
        this.version = version;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public HTTPResponseInMemoryMessage(long serial, byte[] version, byte[] statusCode, byte[] reasonPhrase, byte[] body) {
        this(serial, version, statusCode, reasonPhrase);
        MessageBody msgBody = new MessageBody(new ByteArrayInputStream(body), body.length);
        super.setOriginalMessageBody(msgBody);
    }

    protected void setBaseHeaders(IHTTPMessage base) {
        for (IHTTPHeader h : base.getHeaders()) {
            if (h.isFieldNameEqualsTo(IHTTPHeader.CONTENT_LENGTH_A)) continue;
            this.setHeader(h.getName(), h.getValue());
        }
    }

    public HTTPResponseInMemoryMessage(IHTTPResponseMessage base, byte[] body) {
        this(base.getSerial(), base.getHTTPVersionAsBytes(), base.getStatusCodeAsBytes(), base.getReasonPhraseAsBytes(), body);
        this.setBaseHeaders(base);
    }

    public String getHTTPVersionAsString() {
        return new String(this.version);
    }

    public byte[] getHTTPVersionAsBytes() {
        return this.version;
    }

    public String getStatusCodeAsString() {
        return new String(this.statusCode);
    }

    public byte[] getStatusCodeAsBytes() {
        return this.statusCode;
    }

    public String getReasonPhraseAsString() {
        return new String(this.reasonPhrase);
    }

    public byte[] getReasonPhraseAsBytes() {
        return this.reasonPhrase;
    }

    protected void writeFirstLine(OutputStream out) throws IOException {
        out.write(this.version);
        out.write(32);
        out.write(this.statusCode);
        out.write(32);
        out.write(this.reasonPhrase);
        out.write(13);
        out.write(10);
    }
}

