/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.core.IClientConnection;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.BifurcatedOutputStream;
import org.eclipse.actf.util.internal.httpproxy.core.ClientConnectionListener;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPRequestMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPRequestReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.RequestDispatcher;
import org.eclipse.actf.util.internal.httpproxy.core.ServerConnection;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryOutputStream;

public abstract class ClientConnection
implements Runnable,
IClientConnection {
    private static final Logger LOGGER = Logger.getLogger(ClientConnection.class);
    private final ClientConnectionListener clientConnectionListener;
    private final int fQueueSize;
    private long fKeepAlive;
    private Socket fClientSocket;
    private InputStream fClientIn;
    private BufferedOutputStream fClientOut;
    private HTTPRequestReader fReader;
    private RequestDispatcher fDispatcher;
    private long fLastReadTime = 0L;
    private long fMessageSerial = 0L;
    private boolean isHandlingRequest;
    private String connectionName;

    protected void setConnectionName(String name) {
        this.connectionName = name;
    }

    protected int getQueueSize() {
        return this.fQueueSize;
    }

    protected ClientConnection(ClientConnectionListener clientConnectionListener, int queueSize) {
        this.clientConnectionListener = clientConnectionListener;
        this.fQueueSize = queueSize;
    }

    public void resetConnection() {
        try {
            if (this.fClientSocket != null) {
                if (this.fClientIn != null) {
                    this.fClientIn.close();
                }
                if (this.fClientOut != null) {
                    this.fClientOut.close();
                }
                if (!this.fClientSocket.isClosed()) {
                    this.fClientSocket.setSoLinger(true, 0);
                    this.fClientSocket.close();
                }
                this.fClientSocket = null;
            }
        }
        catch (IOException ex) {
            this.WARNING("Failed to shut down a client output connection (IOException): " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public String close() {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Shutdown a client socket: lastReadTime=" + this.fLastReadTime);
        }
        if (this.fDispatcher != null) {
            this.fDispatcher.close();
        }
        if (this.fClientSocket != null) {
            try {
                this.fClientSocket.shutdownInput();
                if (this.fClientIn != null) {
                    this.fClientIn.close();
                }
            }
            catch (IOException ex) {
                this.WARNING("Failed to close a client connection (IOException): " + ex.getMessage());
            }
        }
        String cNameTmp = this.connectionName;
        this.connectionName = null;
        this.fClientSocket = null;
        this.fClientOut = null;
        this.fReader = null;
        this.fDispatcher = null;
        this.clientConnectionListener.connectionClosed(this);
        return cNameTmp;
    }

    protected void initInternal(Socket clientSock, long keepAlive, int timeout, RequestDispatcher dispatcher) throws IOException {
        this.fClientSocket = clientSock;
        this.fClientSocket.setSoTimeout(timeout);
        this.fClientIn = clientSock.getInputStream();
        this.fClientOut = new BufferedOutputStream(new SocketTimeoutRetryOutputStream(clientSock.getOutputStream()));
        this.fKeepAlive = keepAlive;
        this.fReader = dispatcher.createHTTPRequestReader(this.fClientIn);
        this.isHandlingRequest = false;
        this.fDispatcher = dispatcher;
        this.fDispatcher.start();
        this.DEBUG("Initialized");
    }

    protected HTTPRequestMessage createHTTPRequestMessage(long msgSerial) {
        return new HTTPRequestMessage(msgSerial);
    }

    public Socket getClientSocket() {
        return this.fClientSocket;
    }

    public int getCurrentServerGroupIndex() {
        return this.clientConnectionListener.getCurrentServerGroupIndex();
    }

    public synchronized boolean isHandlingRequest() {
        return this.isHandlingRequest;
    }

    private synchronized void setHandlingRequest(boolean b) {
        this.isHandlingRequest = b;
        if (!this.isHandlingRequest) {
            this.notify();
        }
    }

    private synchronized void waitHandlingRequestFinish() throws InterruptedException {
        while (this.isHandlingRequest) {
            this.wait();
        }
    }

    protected void requestReceived(IHTTPRequestMessage request) {
    }

    public void sendResponse(long timeout, IHTTPResponseMessage response, boolean readyToHandleRequest) throws InterruptedException, IOException, TimeoutException {
        if (this.fClientOut == null) {
            return;
        }
        if (!this.isHandlingRequest()) {
            System.err.println("*****INVALID STATE: response=" + response);
            System.exit(-1);
            return;
        }
        try {
            StringBuffer sb;
            if (LOGGER.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("Send a response to the client: serial=").append(response.getSerial());
                sb.append(", tid=").append(response.getTid());
                this.DEBUG(sb.toString());
            }
            if (LOGGER.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("Response arrived: tid=").append(response.getTid());
                sb.append(", msgSerial=").append(response.getSerial());
                sb.append("\n_______________________________________________________\n");
                try {
                    ByteArrayOutputStream ob = new ByteArrayOutputStream();
                    BifurcatedOutputStream o = new BifurcatedOutputStream(this.fClientOut, ob);
                    response.write(timeout, o);
                    ob.close();
                    sb.append(ob.toString());
                }
                catch (Exception exception) {}
                sb.append("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
                this.DEBUG(sb.toString());
            } else {
                response.write(timeout, this.fClientOut);
            }
            this.fClientOut.flush();
            if (response.isConnectionToBeClosed()) {
                this.fClientSocket.shutdownOutput();
                throw new InterruptedException("This connection is no longer available.");
            }
        }
        finally {
            assert (this.isHandlingRequest());
            if (readyToHandleRequest) {
                this.setHandlingRequest(false);
            }
        }
    }

    public void sendResponse(long timeout, IHTTPResponseMessage response) throws InterruptedException, TimeoutException, IOException {
        this.sendResponse(timeout, response, true);
    }

    public void sendResponse(IHTTPResponseMessage response) throws InterruptedException, IOException {
        try {
            this.sendResponse(0L, response);
        }
        catch (TimeoutException e) {
            throw new IOException("Timeout: " + e.getMessage());
        }
    }

    public void allowTunnel(IHTTPRequestMessage req, ServerConnection sc, long timeout) throws InterruptedException, TimeoutException, IOException {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("CONNECT to " + sc.toString());
        }
        try {
            this.sendResponse(timeout, new HTTPResponseInMemoryMessage(req.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "200".getBytes(), "OK".getBytes(), IHTTPResponseMessage.EMPTY_BODY), false);
            TunnelThread c2s = new TunnelThread(this.fClientIn, sc.getOutputStream());
            TunnelThread s2c = new TunnelThread(sc.getInputStream(), this.fClientOut);
            this.DEBUG("Tunnel is started.");
            c2s.start();
            s2c.start();
            c2s.waitExit();
            s2c.waitExit();
            this.DEBUG("Tunnel is finished.");
        }
        finally {
            this.setHandlingRequest(false);
        }
    }

    public void rejectTunnel(IHTTPRequestMessage req, long timeout) throws InterruptedException, TimeoutException, IOException {
        this.sendResponse(timeout, new HTTPResponseInMemoryMessage(req.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "405".getBytes(), "Method Not Allowed".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 10[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void DEBUG(String name, String msg) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(name).append(": ");
            sb.append(msg);
            LOGGER.debug(sb.toString());
        }
    }

    private final void DEBUG(String msg) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.connectionName).append(": ");
            sb.append(msg);
            LOGGER.debug(sb.toString());
        }
    }

    private final void WARNING(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.connectionName).append(": ");
        sb.append(msg);
        LOGGER.warning(sb.toString());
    }

    private class TunnelThread
    extends Thread {
        private byte[] buffer;
        private static final int DEFUALT_TUNNEL_BUFFER_SIZE = 1024;
        private InputStream is;
        private OutputStream os;
        private boolean exited;

        private synchronized void exit() {
            this.exited = true;
            this.notifyAll();
        }

        public synchronized void waitExit() {
            while (true) {
                try {
                    do {
                        this.wait();
                    } while (!this.exited);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public void run() {
            try {
                try {
                    int size;
                    while ((size = this.is.available()) >= 0) {
                        if (size > this.buffer.length) {
                            this.buffer = new byte[size];
                        }
                        if ((size = this.is.read(this.buffer)) >= 0) {
                            if (LOGGER.isDebugEnabled()) {
                                ClientConnection.this.DEBUG("----TUNNEL--->\n" + (size > 0 ? new String(this.buffer, 0, size) : "") + "\n----TUNNEL--->\n");
                            }
                            this.os.write(this.buffer, 0, size);
                            this.os.flush();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (Throwable throwable) {
                try {
                    this.is.close();
                    this.os.close();
                }
                catch (IOException iOException) {}
                this.exit();
                throw throwable;
            }
            try {
                this.is.close();
                this.os.close();
            }
            catch (IOException iOException) {}
            this.exit();
        }

        TunnelThread(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
            this.buffer = new byte[1024];
            this.exited = false;
        }
    }
}

