/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.httpproxy.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;

public class Logger {
    private static final String COMMA_SPACE = ", ";
    private static String PROP_LOGGING_CONFIGURATION = "httpproxy.conf.logging";
    public static final String DEFAULT_LOGGING_CONFIGURATION = "logging.conf";
    private final java.util.logging.Logger fDelegate;

    public static void setConfigPropertyName(String name) {
        PROP_LOGGING_CONFIGURATION = name;
    }

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz);
    }

    public static void configure() throws Exception {
        String config = System.getProperty(PROP_LOGGING_CONFIGURATION, DEFAULT_LOGGING_CONFIGURATION);
        Properties props = new Properties();
        IOException exception = null;
        if (config != null) {
            try {
                FileInputStream in = new FileInputStream(config);
                LogManager.getLogManager().readConfiguration(in);
                in = new FileInputStream(config);
                props.load(in);
            }
            catch (FileNotFoundException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        java.util.logging.Logger l = java.util.logging.Logger.getLogger("");
        l.setLevel(Level.ALL);
        if (exception != null) {
            throw exception;
        }
    }

    public static void configure(InputStream configIS) throws Exception {
        IOException exception = null;
        if (configIS != null) {
            try {
                LogManager.getLogManager().readConfiguration(configIS);
            }
            catch (FileNotFoundException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
        }
        java.util.logging.Logger l = java.util.logging.Logger.getLogger("");
        l.setLevel(Level.ALL);
        if (exception != null) {
            throw exception;
        }
    }

    private Logger(Class clazz) {
        this.fDelegate = java.util.logging.Logger.getLogger(clazz.getName());
    }

    public final boolean isDebugEnabled() {
        return this.fDelegate.isLoggable(Level.FINE);
    }

    public final boolean isMethodTracingEnabled() {
        return this.fDelegate.isLoggable(Level.FINER);
    }

    private final String createMessage(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(msg);
        return sb.toString();
    }

    public void fatal(String msg) {
        this.fDelegate.severe(this.createMessage(msg));
    }

    public void fatal(String msg, Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append(msg);
        sb.append(COMMA_SPACE);
        sb.append(this.dumpStackTrace(e));
        this.fDelegate.severe(sb.toString());
    }

    public void warning(String msg) {
        this.fDelegate.warning(this.createMessage(msg));
    }

    public void warning(String msg, Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append(msg);
        sb.append(COMMA_SPACE);
        sb.append(this.dumpStackTrace(e));
        this.fDelegate.warning(sb.toString());
    }

    public void info(String msg) {
        this.fDelegate.info(this.createMessage(msg));
    }

    public void debug(String msg) {
        this.fDelegate.fine(this.createMessage(msg));
    }

    public void debug(String msg, Throwable e) {
        StringBuffer sb = new StringBuffer();
        sb.append(msg);
        sb.append(COMMA_SPACE);
        sb.append(this.dumpStackTrace(e));
        this.fDelegate.fine(sb.toString());
    }

    private StringBuffer dumpStackTrace(Throwable e) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        e.printStackTrace(pw);
        pw.flush();
        return w.getBuffer();
    }
}

