/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.httpproxy.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap
extends TreeMap<String, Object> {
    private static final long serialVersionUID = 6681131647931821052L;
    private final int maxSize;
    private final int evictSize;
    private final LinkedList<Object> accessList = new LinkedList();

    public CacheMap(int maxSize, int evictSize) {
        this.maxSize = maxSize;
        this.evictSize = evictSize;
    }

    private void evict() {
        Iterator it = this.accessList.iterator();
        int i = 0;
        while (i < this.evictSize) {
            if (!it.hasNext()) {
                return;
            }
            Object key = it.next();
            this.remove(key);
            it.remove();
            ++i;
        }
    }

    private int searchAccessList(Object key) {
        return this.accessList.indexOf(key);
    }

    private void accessEntry(Object key) {
        int idx = this.searchAccessList(key);
        if (idx >= 0) {
            this.accessList.remove(idx);
        }
        this.accessList.add(key);
    }

    @Override
    public Object put(String key, Object val) {
        if (this.size() >= this.maxSize) {
            this.evict();
        }
        this.accessEntry(key);
        return super.put(key, val);
    }

    @Override
    public Object get(Object key) {
        this.accessEntry(key);
        return super.get(key);
    }

    public Object matchStartsWith(String prefix) {
        String okey;
        SortedMap smap = super.tailMap(prefix);
        try {
            okey = smap.firstKey();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        if (!(okey instanceof String)) {
            return null;
        }
        String key = okey;
        if (!key.startsWith(prefix)) {
            return null;
        }
        return super.get(key);
    }
}

