/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.runtime;

import java.lang.reflect.Method;
import org.eclipse.actf.core.runtime.IRuntimeContext;

public class RuntimeContextFactory {
    public static final String RUNTIME_CONTEXT_CLASSNAME_KEY = "org.eclipse.actf.core.runtimeContext";
    private static RuntimeContextFactory factoryInstance;
    private IRuntimeContext contextInstance;

    protected RuntimeContextFactory() {
    }

    public static RuntimeContextFactory getInstance() {
        if (factoryInstance == null) {
            factoryInstance = new RuntimeContextFactory();
        }
        return factoryInstance;
    }

    public IRuntimeContext getRuntimeContext() {
        if (this.contextInstance == null) {
            this.contextInstance = this.createRuntimeContext();
        }
        return this.contextInstance;
    }

    private IRuntimeContext createRuntimeContext() {
        String clsName = "org.eclipse.actf.core.runtime.StandaloneRuntimeContext";
        String contextProp = System.getProperty(RUNTIME_CONTEXT_CLASSNAME_KEY);
        IRuntimeContext context = null;
        if (contextProp != null && contextProp.length() > 0) {
            clsName = contextProp;
        } else {
            try {
                boolean inEclipse;
                Class<?> platformCls = Class.forName("org.eclipse.core.runtime.Platform");
                Method isRunning = platformCls.getMethod("isRunning", null);
                if (isRunning != null && (inEclipse = ((Boolean)isRunning.invoke(null, null)).booleanValue())) {
                    clsName = "org.eclipse.actf.core.runtime.EclipseRuntimeContext";
                }
            }
            catch (Exception exception) {}
        }
        try {
            context = (IRuntimeContext)Class.forName(clsName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return context;
    }
}

