/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.bridge;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.internal.flash.bridge.WaXcodingConfig;
import org.eclipse.actf.model.internal.flash.proxy.HTTPLocalServerSWFFactory;
import org.eclipse.actf.model.internal.flash.proxy.ProxyTranscoderSWFFactory;
import org.eclipse.actf.model.internal.flash.proxy.SWFBootloaderFactory;
import org.eclipse.actf.model.internal.flash.proxy.SWFSecretManager;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.HTTPProxyFactory;
import org.eclipse.actf.util.httpproxy.IHTTPProxy;
import org.eclipse.actf.util.httpproxy.ProxyConfig;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServerFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoderFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverriderFactory;
import org.eclipse.actf.util.httpproxy.proxy.ISecretManager;
import org.eclipse.actf.util.httpproxy.util.Logger;

public class WaXcodingImpl
implements IWaXcoding {
    private IHTTPProxy proxy;
    private ProxyConfig proxyConfig = new ProxyConfig();
    private ExternalProxyConfig exProxyConfig = new ExternalProxyConfig();
    public WaXcodingConfig waxConfig = WaXcodingConfig.getInstance();
    private static final String logConfig = "handlers = java.util.logging.ConsoleHandler, java.util.logging.FileHandler\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=java.util.logging.SimpleFormatter\njava.util.logging.FileHandler.level=FINEST\njava.util.logging.FileHandler.pattern=c:/waxcoding.log\njava.util.logging.FileHandler.formatter=java.util.logging.SimpleFormatter\n";
    private static final IWaXcoding instance = new WaXcodingImpl();

    public boolean start(boolean initLogger) {
        if (this.proxy != null) {
            return false;
        }
        ByteArrayInputStream is = null;
        if (initLogger) {
            is = new ByteArrayInputStream(logConfig.getBytes());
        }
        try {
            Logger.configure(is);
        }
        catch (Exception exception) {}
        this.proxy = HTTPProxyFactory.newProxy((ProxyConfig)this.proxyConfig, (ExternalProxyConfig)this.exProxyConfig);
        if (this.proxy == null) {
            return false;
        }
        this.proxy.startThread();
        return true;
    }

    public boolean stop() {
        if (this.proxy != null) {
            this.proxy.stopThread();
            this.proxy = null;
        }
        return true;
    }

    public String getSecret(String id, boolean remove) {
        return this.proxy.getSecret(id, remove);
    }

    public void setPort(int port) {
        this.proxyConfig.setPort(port);
    }

    public int getPort() {
        if (this.proxy != null) {
            return this.proxy.getListenPort();
        }
        return this.proxyConfig.getPort();
    }

    public void setExternalProxyFlag(boolean flag) {
        this.exProxyConfig.setExternalProxyFlag(flag);
    }

    public void setExternalProxy(String host, int port) {
        this.exProxyConfig.setExternalProxy(host, port);
    }

    public void setSWFTranscodingFlag(boolean flag) {
        this.waxConfig.setSWFTranscodingFlag(flag);
    }

    public void setSWFTranscodingMinimumVersion(int version) {
        this.waxConfig.setSWFTranscodingMinimumVersion(version);
    }

    public void setSWFTranscodingImposedFile(InputStream is) {
        this.waxConfig.setSWFTranscodingImposedFile(is);
    }

    public void setMaxConnection(int connections) {
        this.proxyConfig.setMaxConnection(connections);
    }

    public void setTimeout(int timeout) {
        this.proxyConfig.setTimeout(timeout);
    }

    private WaXcodingImpl() {
        this.proxyConfig.setProxyTranscoderFactory((IHTTPProxyTranscoderFactory)new ProxyTranscoderSWFFactory());
        this.proxyConfig.setSessionOverriderFactory((IHTTPSessionOverriderFactory)new SWFBootloaderFactory());
        this.proxyConfig.setLocalServerFactory((IHTTPLocalServerFactory)new HTTPLocalServerSWFFactory());
        this.proxyConfig.setSecretManager((ISecretManager)new SWFSecretManager());
    }

    public static IWaXcoding getInstance() {
        return instance;
    }

    public void setSWFBootloaderFlag(boolean flag) {
        this.waxConfig.setSWFBootloaderFlag(flag);
    }

    public void setSWFBootloader(InputStream is) {
        this.waxConfig.setSWFBootLoader(is);
    }

    public void setSWFBootloaderV9(InputStream is) {
        this.waxConfig.setSWFBootLoaderV9(is);
    }

    public void setSWFBridgeInit(InputStream is) {
        this.waxConfig.setSWFBridgeInit(is);
    }

    public void setSWFBridgeInitV9(InputStream is) {
        this.waxConfig.setSWFBridgeInitV9(is);
    }
}

