/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.scripteditor.actions;

import org.eclipse.actf.ai.internal.ui.scripteditor.EditPanelTab;
import org.eclipse.actf.ai.internal.ui.scripteditor.PreviewPanel;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.data.XMLFileSaveUtil;
import org.eclipse.actf.ai.scripteditor.reader.SAXReader;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.ScriptListView;
import org.eclipse.actf.ai.ui.scripteditor.views.TimeLineView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class FileOpenAction
implements IWorkbenchWindowActionDelegate,
IUNIT {
    private ScriptData instScriptData = null;
    private EditPanelTab instEditPanelTab = null;
    private TimeLineView instTimeLine = null;
    private PreviewPanel instPreviewPanel = null;
    private ScriptListView instScriptList = null;
    private String[] EXTENSIONS = new String[]{"*.xml", "*"};
    private String saveFileName = "";
    private String currentURLMovie = "about:blank";

    private void pickupInstViewPart() {
        if (this.instEditPanelTab == null) {
            this.instEditPanelTab = EditPanelView.getInstance().getInstanceTabEditPanel();
        }
        if (this.instTimeLine == null) {
            this.instTimeLine = TimeLineView.getInstance();
        }
        if (this.instPreviewPanel == null) {
            this.instPreviewPanel = PreviewPanel.getInstance();
        }
        if (this.instScriptList == null) {
            this.instScriptList = ScriptListView.getInstance();
        }
        if (this.instScriptData == null) {
            this.instScriptData = ScriptData.getInstance();
        }
    }

    private void preProcessLoadFile() {
        this.instScriptData.clearScriptData();
        this.instTimeLine.reqStoreVolLvlFilePath(null);
    }

    private void postProcessLoadFile() {
        this.instScriptList.getInstScriptList().reloadScriptList();
        this.instEditPanelTab.initDispEditPanel();
        EditPanelView.getInstance().getInstanceTabSelWAVFile().initDescriptionStruct();
        EditPanelView.getInstance().getInstanceTabSelWAVFile().initDispSelWavFile();
        this.instPreviewPanel.setURLMovie(this.currentURLMovie);
        this.instTimeLine.reqStoreXMLFilePath(this.saveFileName);
        this.instTimeLine.reqExpandTimeLine();
        this.instTimeLine.reqRedrawTimeLineCanvas(1);
        this.instTimeLine.reqLoadVolumeLevelData();
        this.instTimeLine.reqRedrawVolumeLevelCanvas(2);
        this.instTimeLine.refreshScriptAudio();
        this.instTimeLine.rewindActionTimeLine();
    }

    private void loadFile(String fname) {
        SAXReader loader = null;
        try {
            try {
                loader = new SAXReader();
                loader.startSAXReader(fname, this.instEditPanelTab);
                this.currentURLMovie = loader.getUri();
            }
            catch (Exception e) {
                e.printStackTrace();
                loader = null;
            }
        }
        finally {
            loader = null;
        }
    }

    public void run(IAction action) {
        boolean start_flg = true;
        this.pickupInstViewPart();
        if (this.instScriptData.getStatusSaveScripts() > 0) {
            XMLFileMessageBox confModifyMB = new XMLFileMessageBox(5, null);
            int result = confModifyMB.open();
            if (result == 64) {
                XMLFileSaveUtil saveFH = new XMLFileSaveUtil();
                String filePath = saveFH.open();
                saveFH.save(filePath, true);
            } else if (result == 256) {
                start_flg = false;
            }
        }
        if (start_flg) {
            FileDialog openDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
            openDialog.setFilterExtensions(this.EXTENSIONS);
            this.saveFileName = openDialog.open();
            if (this.saveFileName != null) {
                this.preProcessLoadFile();
                this.loadFile(this.saveFileName);
                this.postProcessLoadFile();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

