/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.scripteditor.util;

import java.io.File;
import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.voice.IVoice;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.ai.voice.VoiceUtil;

public class VoicePlayerFactory
implements IUNIT {
    private static IVoice voice = VoiceUtil.getVoice();
    private int currentVoicePlayerStatus = -1;
    private static VoicePlayerFactory ownInst = null;
    private static final int VP_EVENT_FIN_SPEAK = 99;
    private static final int TTSFLAG_DEFAULT = 0;
    private static final String JA_KUTEN_CODE1 = "\uff61";
    private static final String JA_KUTEN_CODE2 = "\u3002";
    private static final String JA_TOUTEN_CODE1 = "\uff64";
    private static final String JA_TOUTEN_CODE2 = "\u3001";
    private static final int JA_KUTEN_COUNT = 5;
    private static final int JA_TOUTEN_COUNT = 2;
    private static final float JA_KANJI_MORA = 1.545f;
    private static final float JA_KANA_MORA = 0.988f;
    private static final float EN_CHAR_MORA = 0.347f;

    public VoicePlayerFactory() {
        ownInst = this;
        voice.setEventListener((IVoiceEventListener)new MyVoiceEventListener());
    }

    public static VoicePlayerFactory getInstance() {
        return ownInst;
    }

    private void addSpeakIndex(int index) {
        if (voice != null) {
            voice.getTTSEngine().speak("", 0, index);
        }
    }

    public void speak(String voiceMessage) {
        voice.speak(voiceMessage, true);
        this.addSpeakIndex(99);
    }

    public void stop() {
        voice.speak("", true);
    }

    public void pause() {
    }

    public void resume() {
    }

    public int getSpeed() {
        return voice.getSpeed();
    }

    public int getPitch() {
        return -1;
    }

    public int getVolume() {
        return -1;
    }

    public void setLang(String language) {
        voice.getTTSEngine().setLanguage(language);
    }

    public void setGender(String gender) {
        voice.getTTSEngine().setGender(gender);
    }

    public void setSpeed(int speed) {
        voice.setSpeed(speed);
    }

    public void setPitch(int pitch) {
    }

    public void setVolume(int volume) {
    }

    public void setPlayVoiceStatus(int stat) {
        this.currentVoicePlayerStatus = stat;
    }

    public boolean getPlayVoiceStatus() {
        return this.currentVoicePlayerStatus > -1;
    }

    public float sumMoraCountEn(String strDesc) {
        float mora = 0.0f;
        String desc = strDesc.trim().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        mora = (float)desc.length() * 0.347f;
        return mora;
    }

    public float sumMoraCountJp(String strDesc) {
        float mora = 0.0f;
        String desc = strDesc.trim().replaceAll("^[\\s\u3000]*", "").replaceAll("[\\s\u3000]*$", "");
        int i = 0;
        while (i < desc.length()) {
            String str;
            char c = strDesc.charAt(i);
            mora = c >= ' ' && c <= '~' ? (mora += 0.347f) : (c >= '\uff61' && c <= '\uff9f' ? (JA_KUTEN_CODE1.equals(str = String.valueOf(c)) ? (mora += 5.0f) : (JA_TOUTEN_CODE1.equals(str) ? (mora += 2.0f) : (mora += 0.988f))) : (JA_KUTEN_CODE2.equals(str = String.valueOf(c)) ? (mora += 5.0f) : (JA_TOUTEN_CODE2.equals(str) ? (mora += 2.0f) : (c >= '\u4e9c' ? (mora += 1.545f) : ('\u3041' <= c && c <= '\u30f6' ? (mora += 0.988f) : (mora += 0.347f))))));
            ++i;
        }
        return mora;
    }

    public boolean canSpeakToFile() {
        return voice.getTTSEngine().canSpeakToFile();
    }

    public boolean speakToFile(String target, File targetFile) {
        ITTSEngine engine = voice.getTTSEngine();
        if (engine.canSpeakToFile()) {
            return engine.speakToFile(target, targetFile);
        }
        return false;
    }

    class MyVoiceEventListener
    implements IVoiceEventListener {
        MyVoiceEventListener() {
        }

        public void indexReceived(int index) {
            if (index == -1 && VoicePlayerFactory.this.currentVoicePlayerStatus == 0) {
                VoicePlayerFactory.this.setPlayVoiceStatus(1);
            } else if (index == 99 && VoicePlayerFactory.this.currentVoicePlayerStatus == 1) {
                VoicePlayerFactory.this.setPlayVoiceStatus(-1);
            }
        }
    }
}

