/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.ssl;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.tcf.Activator;
import org.eclipse.tcf.core.Base64;
import org.eclipse.tcf.protocol.Protocol;

public class TCFSecurityManager {
    public static File getCertificatesDirectory() throws IOException {
        File certs;
        try {
            certs = Activator.getDefault().getStateLocation().append("certificates").toFile();
        }
        catch (IllegalStateException e) {
            certs = new File(System.getProperty("user.home"), ".tcf");
            certs = new File(certs, "certificates");
        }
        if (!certs.exists() && !certs.mkdirs()) {
            throw new IOException("Cannot create directory: " + certs);
        }
        return certs;
    }

    public static File getSysCertificatesDirectory() {
        File file = null;
        String osname = System.getProperty("os.name", "");
        if (osname.startsWith("Windows")) {
            Process prs = null;
            BufferedReader inp = null;
            try {
                String s;
                String sys_root = "SystemRoot";
                prs = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "set", sys_root}, null);
                inp = new BufferedReader(new InputStreamReader(prs.getInputStream()));
                while ((s = inp.readLine()) != null) {
                    File root;
                    String name;
                    int i = s.indexOf(61);
                    if (i <= 0 || !(name = s.substring(0, i)).equalsIgnoreCase(sys_root) || !(root = new File(s.substring(i + 1))).exists()) continue;
                    file = new File(root, "TCF/ssl");
                }
                try {
                    prs.getErrorStream().close();
                    prs.getOutputStream().close();
                    inp.close();
                }
                catch (IOException x) {
                    Protocol.log((String)"Cannot close child process I/O streams", (Throwable)x);
                }
                prs.waitFor();
            }
            catch (Throwable x) {
                Protocol.log((String)"Cannot get system directory name", (Throwable)x);
                try {
                    if (prs != null) {
                        prs.getErrorStream().close();
                        prs.getOutputStream().close();
                    }
                    if (inp != null) {
                        inp.close();
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            file = new File("/etc/tcf/ssl");
        }
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        return file;
    }

    public static SSLContext createSSLContext() {
        try {
            final File usr_certs = TCFSecurityManager.getCertificatesDirectory();
            final File sys_certs = TCFSecurityManager.getSysCertificatesDirectory();
            if (!usr_certs.exists() && !usr_certs.mkdirs()) {
                throw new Exception("Cannot create directory: " + usr_certs);
            }
            final CertificateFactory cf = CertificateFactory.getInstance("X.509");
            SSLContext context = SSLContext.getInstance("TLS");
            X509ExtendedKeyManager km = new X509ExtendedKeyManager(){

                @Override
                public X509Certificate[] getCertificateChain(String alias) {
                    File f = new File(usr_certs, "local.cert");
                    if (!f.exists() && sys_certs != null) {
                        f = new File(sys_certs, "local.cert");
                    }
                    BufferedInputStream inp = null;
                    try {
                        inp = new BufferedInputStream(new FileInputStream(f));
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(inp);
                        ((InputStream)inp).close();
                        return new X509Certificate[]{cert};
                    }
                    catch (Throwable x) {
                        Protocol.log((String)("Cannot read certificate: " + f), (Throwable)x);
                        try {
                            if (inp != null) {
                                ((InputStream)inp).close();
                            }
                        }
                        catch (IOException e) {
                            Protocol.log((String)("Cannot close certificate file: " + f), (Throwable)x);
                        }
                        return null;
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public PrivateKey getPrivateKey(String alias) {
                    File f = new File(usr_certs, "local.priv");
                    if (!f.exists() && sys_certs != null) {
                        f = new File(sys_certs, "local.priv");
                    }
                    BufferedReader r = null;
                    try {
                        r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "ASCII"));
                        StringBuffer bf = new StringBuffer();
                        boolean app = false;
                        while (true) {
                            String s;
                            if ((s = r.readLine()) == null) {
                                throw new Exception("Invalid format");
                            }
                            if (s.indexOf("-----BEGIN ") == 0) {
                                app = true;
                                continue;
                            }
                            if (s.indexOf("-----END ") == 0) break;
                            if (!app) continue;
                            bf.append(s);
                        }
                        KeyFactory kf = KeyFactory.getInstance("RSA");
                        byte[] bytes = Base64.toByteArray((char[])bf.toString().toCharArray());
                        PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(bytes));
                        return privateKey;
                    }
                    catch (Exception x) {
                        Protocol.log((String)("Cannot read private key: " + f), (Throwable)x);
                        try {
                            if (r == null) return null;
                            r.close();
                            return null;
                        }
                        catch (IOException e) {
                            Protocol.log((String)("Cannot close private key file: " + f), (Throwable)x);
                        }
                        return null;
                    }
                    finally {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }

                @Override
                public String[] getClientAliases(String keyType, Principal[] issuers) {
                    return new String[]{"TCF"};
                }

                @Override
                public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
                    return "TCF";
                }

                @Override
                public String[] getServerAliases(String keyType, Principal[] issuers) {
                    return new String[]{"TCF"};
                }

                @Override
                public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
                    return "TCF";
                }
            };
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String auth_type) throws CertificateException {
                    if ("RSA".equals(auth_type) && chain != null && chain.length == 1) {
                        X509Certificate[] x509CertificateArray = this.getAcceptedIssuers();
                        int n = x509CertificateArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            X509Certificate cert = x509CertificateArray[n2];
                            if (cert.equals(chain[0])) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    throw new CertificateException("Client certificate validation failed");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String auth_type) throws CertificateException {
                    if (chain != null && chain.length == 1) {
                        X509Certificate[] x509CertificateArray = this.getAcceptedIssuers();
                        int n = x509CertificateArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            X509Certificate cert = x509CertificateArray[n2];
                            if (cert.equals(chain[0])) {
                                return;
                            }
                            ++n2;
                        }
                    }
                    throw new CertificateException("Server certificate validation failed");
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    String[] arr;
                    int n;
                    ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
                    String[] usr_list = usr_certs.list();
                    if (usr_list != null) {
                        String[] stringArray = usr_list;
                        n = usr_list.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fnm = stringArray[n2];
                            if (fnm.endsWith(".cert")) {
                                BufferedInputStream inp = null;
                                try {
                                    inp = new BufferedInputStream(new FileInputStream(new File(usr_certs, fnm)));
                                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inp);
                                    ((InputStream)inp).close();
                                    list.add(cert);
                                }
                                catch (Throwable x) {
                                    Protocol.log((String)("Cannot load certificate: " + fnm), (Throwable)x);
                                    try {
                                        if (inp != null) {
                                            ((InputStream)inp).close();
                                        }
                                    }
                                    catch (IOException e) {
                                        Protocol.log((String)("Cannot close certificate file: " + fnm), (Throwable)x);
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    if (sys_certs != null && (arr = sys_certs.list()) != null) {
                        String[] stringArray = arr;
                        int n3 = arr.length;
                        n = 0;
                        while (n < n3) {
                            String fnm = stringArray[n];
                            if (fnm.endsWith(".cert")) {
                                BufferedInputStream inp = null;
                                try {
                                    inp = new BufferedInputStream(new FileInputStream(new File(sys_certs, fnm)));
                                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inp);
                                    ((InputStream)inp).close();
                                    list.add(cert);
                                }
                                catch (Throwable x) {
                                    Protocol.log((String)("Cannot load certificate: " + fnm), (Throwable)x);
                                    try {
                                        if (inp != null) {
                                            ((InputStream)inp).close();
                                        }
                                    }
                                    catch (IOException e) {
                                        Protocol.log((String)("Cannot close certificate file: " + fnm), (Throwable)x);
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                    return list.toArray(new X509Certificate[list.size()]);
                }
            };
            context.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
            return context;
        }
        catch (Throwable x) {
            Protocol.log((String)"Cannot initialize SSL context", (Throwable)x);
            return null;
        }
    }
}

