/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards.newWizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public class NewWizardContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (inputElement instanceof IWizardRegistry) {
            IWizardRegistry registry = (IWizardRegistry)inputElement;
            IWizardDescriptor[] primary = registry.getPrimaryWizards();
            if (primary != null && primary.length > 0) {
                children.addAll(Arrays.asList(primary));
            }
            children.addAll(Arrays.asList(this.getChildren(registry.getRootCategory())));
            if (children.size() == 1 && children.get(0) instanceof IWizardCategory) {
                IWizardCategory category = (IWizardCategory)children.get(0);
                children.clear();
                children.addAll(Arrays.asList(this.getChildren(category)));
            }
        } else if (inputElement instanceof IWizardCategory) {
            return this.getChildren(inputElement);
        }
        return children.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement instanceof IWizardCategory) {
            IWizardCategory[] iWizardCategoryArray = ((IWizardCategory)parentElement).getCategories();
            int n = iWizardCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardCategory category = iWizardCategoryArray[n2];
                if (category.getCategories() != null && category.getCategories().length > 0 || category.getWizards() != null && category.getWizards().length > 0) {
                    children.add(category);
                }
                ++n2;
            }
            children.addAll(Arrays.asList(((IWizardCategory)parentElement).getWizards()));
            Iterator it = children.iterator();
            while (it.hasNext()) {
                if (!WorkbenchActivityHelper.filterItem(it.next())) continue;
                it.remove();
            }
            return children.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IWizardCategory) {
            return ((IWizardCategory)element).getParent();
        }
        if (element instanceof IWizardDescriptor) {
            return ((IWizardDescriptor)element).getCategory();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }
}

