/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime;

import java.util.EventObject;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.PendingOperationModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IPendingOperationNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.nodes.PendingOperationNode;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.events.TreeViewerListener;

public class ContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    ITreeViewerListener listener = null;

    public Object[] getChildren(final Object parentElement) {
        Object[] children = NO_ELEMENTS;
        if (parentElement instanceof IPeerNode) {
            Object[] objectArray;
            IRuntimeModel model = ModelManager.getRuntimeModel((IPeerNode)((IPeerNode)parentElement));
            if (this.isRuntimeModelNodeVisible()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = model;
            } else {
                objectArray = this.getChildren(model);
            }
            return objectArray;
        }
        if (parentElement instanceof IRuntimeModel) {
            final IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)((IRuntimeModel)parentElement).getAdapter(IAsyncRefreshableCtx.class);
            if (refreshable != null) {
                if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.PENDING)) {
                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                    PendingOperationNode pendingNode = new PendingOperationNode();
                    pendingNode.setParent((IContainerModelNode)((IRuntimeModel)parentElement));
                    refreshable.setPendingOperationNode((PendingOperationModelNode)pendingNode);
                    final IRuntimeModel model = (IRuntimeModel)parentElement;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            final boolean changed = model.setChangeEventsEnabled(false);
                            ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                                    refreshable.setPendingOperationNode(null);
                                    if (changed) {
                                        model.setChangeEventsEnabled(true);
                                    }
                                    ChangeEvent event = new ChangeEvent((Object)model, (Object)"changed", null, null);
                                    EventManager.getInstance().fireEvent((EventObject)event);
                                }
                            });
                        }
                    };
                    Protocol.invokeLater((Runnable)runnable);
                    return new Object[]{refreshable.getPendingOperationNode()};
                }
                if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.IN_PROGRESS) && ((IRuntimeModel)parentElement).getAutoRefreshInterval() == 0) {
                    Object[] objectArray;
                    if (refreshable.getPendingOperationNode() != null) {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = refreshable.getPendingOperationNode();
                    } else {
                        objectArray = NO_ELEMENTS;
                    }
                    return objectArray;
                }
            }
            children = ((IRuntimeModel)parentElement).getChildren(IProcessContextNode.class).toArray();
        } else if (parentElement instanceof IProcessContextNode) {
            final IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)((IProcessContextNode)parentElement).getAdapter(IAsyncRefreshableCtx.class);
            if (refreshable != null) {
                if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.PENDING)) {
                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                    PendingOperationNode pendingNode = new PendingOperationNode();
                    pendingNode.setParent((IContainerModelNode)((IProcessContextNode)parentElement));
                    refreshable.setPendingOperationNode((PendingOperationModelNode)pendingNode);
                    final IProcessContextNode node = (IProcessContextNode)parentElement;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            final boolean changed = node.setChangeEventsEnabled(false);
                            IRuntimeModel model = (IRuntimeModel)node.getParent(IRuntimeModel.class);
                            if (model != null) {
                                ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((IModelNode)node, (ICallback)new Callback(){

                                    protected void internalDone(Object caller, IStatus status) {
                                        refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                                        refreshable.setPendingOperationNode(null);
                                        if (changed) {
                                            node.setChangeEventsEnabled(true);
                                        }
                                        ChangeEvent event = new ChangeEvent((Object)node, (Object)"changed", null, null);
                                        EventManager.getInstance().fireEvent((EventObject)event);
                                    }
                                });
                            }
                        }
                    };
                    Protocol.invokeLater((Runnable)runnable);
                    return new Object[]{refreshable.getPendingOperationNode()};
                }
                if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.IN_PROGRESS)) {
                    final AtomicReference model = new AtomicReference();
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            model.set((IRuntimeModel)((IProcessContextNode)parentElement).getParent(IRuntimeModel.class));
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    if (model.get() == null || ((IRuntimeModel)model.get()).getAutoRefreshInterval() == 0) {
                        Object[] objectArray;
                        if (refreshable.getPendingOperationNode() != null) {
                            Object[] objectArray4 = new Object[1];
                            objectArray = objectArray4;
                            objectArray4[0] = refreshable.getPendingOperationNode();
                        } else {
                            objectArray = NO_ELEMENTS;
                        }
                        return objectArray;
                    }
                }
            }
            children = ((IProcessContextNode)parentElement).getChildren(IProcessContextNode.class).toArray();
        }
        return children;
    }

    public Object getParent(final Object element) {
        final AtomicReference<Object> parent = new AtomicReference<Object>();
        if (element instanceof IRuntimeModel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    parent.set(((IRuntimeModel)element).getPeerNode());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        } else if (element instanceof IProcessContextNode) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    parent.set(((IProcessContextNode)element).getParent());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        } else if (element instanceof IPendingOperationNode) {
            parent.set(((IPendingOperationNode)element).getParent());
        }
        if (parent.get() instanceof IRuntimeModel) {
            parent.set(this.getParent(parent.get()));
        }
        return parent.get();
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof IRuntimeModel) {
            IRuntimeModel model = (IRuntimeModel)element;
            IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)model.getAdapter(IAsyncRefreshableCtx.class);
            hasChildren = refreshable != null && refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.PENDING) ? true : model.hasChildren();
        } else if (element instanceof IProcessContextNode) {
            final IProcessContextNode context = (IProcessContextNode)element;
            IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)context.getAdapter(IAsyncRefreshableCtx.class);
            if (refreshable != null && refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.PENDING)) {
                hasChildren = true;
            } else {
                final Object[] children = this.getChildren(context);
                if (children.length == 1 && children[0] instanceof IProcessContextNode) {
                    final AtomicBoolean selected = new AtomicBoolean(true);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            IProcessContextNode child = (IProcessContextNode)children[0];
                            if (child != null && context.getSysMonitorContext() != null && child.getSysMonitorContext() != null && context.getSysMonitorContext().getPID() == child.getSysMonitorContext().getPID()) {
                                ISysMonitor.SysMonitorContext smc = context.getSysMonitorContext();
                                if (Integer.valueOf(1).equals(smc.getProperties().get("ExeType"))) {
                                    selected.set(false);
                                } else if (context.getName() != null) {
                                    selected.set(!context.getName().equals(child.getName()));
                                } else if (child.getName() != null) {
                                    selected.set(!child.getName().equals(context.getName()));
                                }
                            }
                        }
                    };
                    Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
                    Protocol.invokeAndWait((Runnable)runnable);
                    hasChildren = selected.get();
                } else {
                    hasChildren = children.length > 0;
                }
            }
        } else if (element instanceof IPeerNode) {
            hasChildren = true;
        }
        return hasChildren;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.listener == null && viewer instanceof TreeViewer) {
            final TreeViewer treeViewer = (TreeViewer)viewer;
            this.listener = new TreeViewerListener();
            treeViewer.addTreeListener(this.listener);
            treeViewer.getTree().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ContentProvider.this.listener != null) {
                        treeViewer.removeTreeListener(ContentProvider.this.listener);
                        ContentProvider.this.listener = null;
                    }
                }
            });
        }
    }

    protected boolean isRuntimeModelNodeVisible() {
        return true;
    }
}

