/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import java.io.File;
import org.eclipse.rap.rwt.osgi.ApplicationLauncher;
import org.eclipse.rap.rwt.osgi.ApplicationReference;
import org.eclipse.rap.rwt.osgi.internal.ApplicationReferenceImpl;
import org.eclipse.rap.rwt.osgi.internal.ApplicationReferencesContainer;
import org.eclipse.rap.rwt.osgi.internal.Matcher;
import org.eclipse.rap.rwt.osgi.internal.ServiceContainer;
import org.eclipse.rwt.application.ApplicationConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLauncherImpl
implements ApplicationLauncher {
    private final Object lock = new Object();
    private final ServiceContainer<ApplicationConfiguration> configurations;
    private final ServiceContainer<HttpService> httpServices;
    private final ApplicationReferencesContainer applicationReferences;
    private BundleContext bundleContext;

    public ApplicationLauncherImpl(BundleContext bundleContext) {
        this.configurations = new ServiceContainer(bundleContext);
        this.httpServices = new ServiceContainer(bundleContext);
        this.applicationReferences = new ApplicationReferencesContainer();
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpService addHttpService(ServiceReference<HttpService> reference) {
        ServiceContainer.ServiceHolder<HttpService> httpServiceHolder;
        Object object = this.lock;
        synchronized (object) {
            httpServiceHolder = this.httpServices.add(reference);
            this.launchAtHttpService(httpServiceHolder);
        }
        return httpServiceHolder.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpService(HttpService httpService) {
        Object object = this.lock;
        synchronized (object) {
            this.httpServices.remove(httpService);
            this.stopApplicationReferences(httpService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationConfiguration addConfiguration(ServiceReference<ApplicationConfiguration> ref) {
        ServiceContainer.ServiceHolder<ApplicationConfiguration> configurationHolder;
        Object object = this.lock;
        synchronized (object) {
            configurationHolder = this.configurations.add(ref);
            this.launchWithConfiguration(configurationHolder);
        }
        return configurationHolder.getService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguration(ApplicationConfiguration configuration) {
        Object object = this.lock;
        synchronized (object) {
            this.configurations.remove(configuration);
            this.stopApplicationReferences(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationReference launch(ApplicationConfiguration configuration, HttpService httpService, HttpContext httpContext, String contextName, String contextDirectory) {
        Object object = this.lock;
        synchronized (object) {
            ApplicationReferenceImpl result = null;
            if (this.isAlive()) {
                result = this.doLaunch(configuration, httpService, httpContext, contextName, contextDirectory);
            }
            return result;
        }
    }

    private ApplicationReferenceImpl doLaunch(ApplicationConfiguration configuration, HttpService httpService, HttpContext httpContext, String contextName, String contextDirectory) {
        ApplicationReferenceImpl result = new ApplicationReferenceImpl(configuration, httpService, httpContext, contextName, contextDirectory, this);
        result.start();
        this.applicationReferences.add(result);
        this.httpServices.add(httpService);
        this.configurations.add(configuration);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Object object = this.lock;
        synchronized (object) {
            this.stopAllApplicationReferences();
            this.configurations.clear();
            this.applicationReferences.clear();
            this.httpServices.clear();
            this.bundleContext = null;
        }
    }

    boolean isAlive() {
        return this.bundleContext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyContextAboutToStop(ApplicationReferenceImpl applicationReference) {
        Object object = this.lock;
        synchronized (object) {
            this.applicationReferences.remove(applicationReference);
        }
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private void launchAtHttpService(ServiceContainer.ServiceHolder<HttpService> httpServiceHolder) {
        ServiceContainer.ServiceHolder<ApplicationConfiguration>[] services;
        ServiceContainer.ServiceHolder<ApplicationConfiguration>[] serviceHolderArray = services = this.configurations.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceContainer.ServiceHolder<ApplicationConfiguration> configurationHolder = serviceHolderArray[n2];
            if (this.matches(httpServiceHolder, configurationHolder)) {
                this.launch(configurationHolder, httpServiceHolder);
            }
            ++n2;
        }
    }

    private void launchWithConfiguration(ServiceContainer.ServiceHolder<ApplicationConfiguration> configurationHolder) {
        ServiceContainer.ServiceHolder<HttpService>[] services;
        ServiceContainer.ServiceHolder<HttpService>[] serviceHolderArray = services = this.httpServices.getServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceContainer.ServiceHolder<HttpService> httpServiceHolder = serviceHolderArray[n2];
            if (this.matches(httpServiceHolder, configurationHolder)) {
                this.launch(configurationHolder, httpServiceHolder);
            }
            ++n2;
        }
    }

    private void launch(ServiceContainer.ServiceHolder<ApplicationConfiguration> configurationHolder, ServiceContainer.ServiceHolder<HttpService> httpServiceHolder) {
        ApplicationConfiguration configuration = configurationHolder.getService();
        HttpService httpService = httpServiceHolder.getService();
        String contextName = this.getContextName(configurationHolder);
        String contextLocation = this.getLocation(contextName, configuration, httpService);
        try {
            this.launch(configuration, httpService, null, contextName, contextLocation);
        }
        catch (RuntimeException rte) {
            this.logProblem("Unable to start RWT application.", rte);
        }
    }

    private String getContextName(ServiceContainer.ServiceHolder<ApplicationConfiguration> configurationHolder) {
        ServiceReference<ApplicationConfiguration> reference = configurationHolder.getReference();
        return (String)reference.getProperty("contextName");
    }

    private void stopApplicationReferences(Object service) {
        ApplicationReferenceImpl[] iterator;
        ApplicationReferenceImpl[] applicationReferenceImplArray = iterator = this.applicationReferences.getAll();
        int n = iterator.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationReferenceImpl applicationReference = applicationReferenceImplArray[n2];
            if (applicationReference.belongsTo(service)) {
                this.stopApplicationReference(applicationReference);
            }
            ++n2;
        }
    }

    private void stopAllApplicationReferences() {
        ApplicationReferenceImpl[] all;
        ApplicationReferenceImpl[] applicationReferenceImplArray = all = this.applicationReferences.getAll();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationReferenceImpl applicationReference = applicationReferenceImplArray[n2];
            this.stopApplicationReference(applicationReference);
            ++n2;
        }
    }

    void stopApplicationReference(ApplicationReferenceImpl applicationReference) {
        try {
            applicationReference.stopApplication();
        }
        catch (RuntimeException rte) {
            this.logProblem("Unable to stop ApplicationReference properly.", rte);
        }
    }

    private boolean matches(ServiceContainer.ServiceHolder<HttpService> httpServiceHolder, ServiceContainer.ServiceHolder<ApplicationConfiguration> configurationHolder) {
        ServiceReference<HttpService> httpServiceRef = httpServiceHolder.getReference();
        ServiceReference<ApplicationConfiguration> configurationRef = configurationHolder.getReference();
        return new Matcher(httpServiceRef, configurationRef).matches();
    }

    private void logProblem(String failureMessage, Throwable failure) {
        ServiceReference logReference = this.bundleContext.getServiceReference(LogService.class.getName());
        if (logReference != null) {
            LogService log = (LogService)this.bundleContext.getService(logReference);
            log.log(1, failureMessage, failure);
        } else {
            System.err.println(failureMessage);
            failure.printStackTrace();
        }
    }

    String getLocation(String contextName, ApplicationConfiguration configuration, HttpService service) {
        String pathToContext = ApplicationLauncherImpl.getContextFileName(contextName, configuration, service);
        File dataFile = this.bundleContext.getDataFile(pathToContext);
        return dataFile.toString();
    }

    static String getContextFileName(String name, ApplicationConfiguration configuration, HttpService service) {
        StringBuilder result = new StringBuilder();
        result.append(name == null ? "rwtcontext" : name);
        result.append("_");
        result.append(configuration.hashCode());
        result.append("_");
        result.append(service.hashCode());
        return result.toString();
    }
}

