/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.weld.logging.XmlLogger;
import org.jboss.weld.xml.XmlSchema;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BeansXmlValidator
implements ErrorHandler {
    private static final StreamSource[] EMPTY_SOURCE_ARRAY = new StreamSource[0];
    private static final String ROOT_ELEMENT_NAME = "beans";
    private static final String VALIDATION_ERROR_CODE_CVC_ELT_1 = "cvc-elt.1";
    private final Schema cdi11Schema;
    private final Schema cdi20Schema;

    public BeansXmlValidator() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        this.cdi11Schema = this.initSchema(factory, XmlSchema.CDI11_SCHEMAS);
        this.cdi20Schema = this.initSchema(factory, XmlSchema.CDI20_SCHEMAS);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="False positive, see https://github.com/spotbugs/spotbugs/issues/259")
    public void validate(URL beansXml, ErrorHandler errorHandler) {
        if (beansXml == null) {
            throw XmlLogger.LOG.loadError("unknown", null);
        }
        if (errorHandler == null) {
            errorHandler = this;
        }
        Schema schema = this.cdi20Schema;
        try (InputStream in = beansXml.openStream();){
            if (in.available() == 0) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, Charset.forName(StandardCharsets.UTF_8.name())));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains(XmlSchema.CDI11.getFileName())) {
                        schema = this.cdi11Schema;
                    } else if (!line.contains(XmlSchema.CDI20.getFileName())) continue;
                    break;
                }
            }
        }
        catch (IOException e) {
            throw XmlLogger.LOG.loadError(beansXml, e);
        }
        if (schema == null) {
            return;
        }
        Validator validator = schema.newValidator();
        validator.setErrorHandler(errorHandler);
        try (InputStream in = beansXml.openStream();){
            validator.validate(new StreamSource(in));
        }
        catch (IOException | SAXException exception) {
            // empty catch block
        }
    }

    public void validate(URL beansXml) {
        this.validate(beansXml, this);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        XmlLogger.LOG.xsdValidationWarning(e.getSystemId(), e.getLineNumber(), e.getMessage());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (e.getMessage().startsWith(VALIDATION_ERROR_CODE_CVC_ELT_1) && e.getMessage().contains(ROOT_ELEMENT_NAME)) {
            return;
        }
        XmlLogger.LOG.xsdValidationError(e.getSystemId(), e.getLineNumber(), e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    private static StreamSource[] loadXsds(XmlSchema[] schemas) {
        ArrayList<StreamSource> xsds = new ArrayList<StreamSource>();
        for (XmlSchema schema : schemas) {
            StreamSource source = BeansXmlValidator.loadXsd(schema.getFileName(), schema.getClassLoader());
            if (source == null) continue;
            xsds.add(source);
        }
        return xsds.toArray(EMPTY_SOURCE_ARRAY);
    }

    private static StreamSource loadXsd(String name, ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new StreamSource(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema initSchema(SchemaFactory factory, XmlSchema[] schemas) {
        Source[] sources = null;
        try {
            sources = BeansXmlValidator.loadXsds(schemas);
            Schema schema = factory.newSchema(sources);
            return schema;
        }
        catch (SAXException e) {
            XmlLogger.LOG.warnf("Error initializing schema from %s", Arrays.toString((Object[])schemas));
            Schema schema = null;
            return schema;
        }
        finally {
            if (sources != null) {
                for (Source source : sources) {
                    try {
                        ((StreamSource)source).getInputStream().close();
                    }
                    catch (IOException e) {
                        XmlLogger.LOG.warn("Error closing schema resource", e);
                    }
                }
            }
        }
    }
}

