/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.jboss.weld.bootstrap.Tracker;
import org.jboss.weld.logging.BootstrapLogger;

final class Trackers {
    private static final Tracker NOOP_INSTANCE = new NoopTracker(){};

    private Trackers() {
    }

    static Tracker create(String startOperation) {
        return Trackers.create().start(startOperation);
    }

    static Tracker create() {
        return BootstrapLogger.TRACKER_LOG.isDebugEnabled() ? new LoggingTracker() : NOOP_INSTANCE;
    }

    private static class LoggingTracker
    implements Tracker {
        private final List<Operation> operations = new LinkedList<Operation>();

        LoggingTracker() {
        }

        @Override
        public Tracker start(String operation) {
            if (!this.operations.isEmpty()) {
                operation = this.operations.get(this.operations.size() - 1).name + " > " + operation;
            }
            this.operations.add(new Operation(operation));
            BootstrapLogger.TRACKER_LOG.debugf("START %s ", operation);
            return this;
        }

        @Override
        public void split(String info) {
            Operation operation = this.operations.get(this.operations.size() - 1);
            BootstrapLogger.TRACKER_LOG.debugf(" TIME %s:%s (%s ms)", operation.name, info, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - operation.start));
        }

        @Override
        public Tracker end() {
            Operation operation = this.operations.remove(this.operations.size() - 1);
            this.logEnd(operation.name, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - operation.start));
            return this;
        }

        @Override
        public void close() {
            ListIterator<Operation> iterator = this.operations.listIterator(this.operations.size());
            while (iterator.hasPrevious()) {
                Operation operation = iterator.previous();
                this.logEnd(operation.name, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - operation.start));
                iterator.remove();
            }
        }

        private void logEnd(String info, long time) {
            BootstrapLogger.TRACKER_LOG.debugf("  END %s (%s ms)", info, time);
        }

        private static class Operation {
            private final String name;
            private final Long start;

            public Operation(String operation) {
                this.name = operation;
                this.start = System.nanoTime();
            }
        }
    }

    private static class NoopTracker
    implements Tracker {
        private NoopTracker() {
        }

        @Override
        public Tracker start(String operation) {
            return this;
        }

        @Override
        public Tracker end() {
            return this;
        }

        @Override
        public void split(String info) {
        }

        @Override
        public void close() {
        }
    }
}

