/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import org.eclipse.persistence.internal.helper.JDK15Platform;
import org.eclipse.persistence.internal.helper.JDKPlatform;
import org.eclipse.persistence.internal.helper.JavaSEPlatform;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class JavaPlatform {
    protected static JDKPlatform platform = null;

    protected static JDKPlatform getPlatform() {
        if (platform == null) {
            if (JavaSEPlatform.CURRENT.atLeast(JavaSEPlatform.v1_6)) {
                try {
                    Class platformClass = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            platformClass = AccessController.doPrivileged(new PrivilegedClassForName("org.eclipse.persistence.internal.helper.JDK16Platform"));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        platformClass = PrivilegedAccessHelper.getClassForName("org.eclipse.persistence.internal.helper.JDK16Platform");
                    }
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            platform = (JDKPlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(platformClass));
                        }
                        catch (PrivilegedActionException privilegedActionException) {}
                    } else {
                        platform = (JDKPlatform)PrivilegedAccessHelper.newInstanceFromClass(platformClass);
                    }
                }
                catch (Exception exception) {}
            }
            if (platform == null) {
                platform = new JDK15Platform();
            }
        }
        return platform;
    }

    public static Boolean conformLike(Object left, Object right) {
        return JavaPlatform.getPlatform().conformLike(left, right);
    }

    public static Boolean conformRegexp(Object left, Object right) {
        return JavaPlatform.getPlatform().conformRegexp(left, right);
    }

    public static boolean isSQLXML(Object object) {
        return JavaPlatform.getPlatform().isSQLXML(object);
    }

    public static String getStringAndFreeSQLXML(Object sqlXml) throws SQLException {
        return JavaPlatform.getPlatform().getStringAndFreeSQLXML(sqlXml);
    }
}

