/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Hashtable;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.databaseaccess.SimpleAppendCallCustomParameter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.Call;

public class Oracle8Platform
extends OraclePlatform {
    protected boolean usesLocatorForLOBWrite = true;
    protected int lobValueLimits = 0;

    protected Hashtable buildFieldTypes() {
        Hashtable fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        return fieldTypeMapping;
    }

    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof Oracle8Platform)) {
            return;
        }
        Oracle8Platform oracle8Platform = (Oracle8Platform)platform;
        oracle8Platform.setShouldUseLocatorForLOBWrite(this.shouldUseLocatorForLOBWrite());
        oracle8Platform.setLobValueLimits(this.getLobValueLimits());
    }

    protected boolean lobValueExceedsLimit(Object value) {
        if (value == null) {
            return false;
        }
        int limit = this.getLobValueLimits();
        if (value instanceof byte[]) {
            return ((byte[])value).length >= limit;
        }
        if (value instanceof String) {
            return ((String)value).length() >= limit;
        }
        return false;
    }

    public Connection getConnection(AbstractSession session, Connection connection) {
        if (session.getServerPlatform() != null && session.getLogin().shouldUseExternalConnectionPooling()) {
            return session.getServerPlatform().unwrapConnection(connection);
        }
        return connection;
    }

    public Object getCustomModifyValueForCall(Call call, Object value, DatabaseField field, boolean shouldBind) {
        Class type = field.getType();
        if (ClassConstants.BLOB.equals(type) || ClassConstants.CLOB.equals(type)) {
            if (value == null) {
                return null;
            }
            value = this.convertToDatabaseType(value);
            if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(value)) {
                ((DatabaseCall)call).addContext(field, value);
                value = ClassConstants.BLOB.equals(type) ? (shouldBind ? (Object)new byte[1] : new SimpleAppendCallCustomParameter("empty_blob()")) : (shouldBind ? new String(" ") : new SimpleAppendCallCustomParameter("empty_clob()"));
            }
            return value;
        }
        return super.getCustomModifyValueForCall(call, value, field, shouldBind);
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField field) {
        Class type;
        if (this.shouldUseLocatorForLOBWrite() && (ClassConstants.BLOB.equals(type = field.getType()) || ClassConstants.CLOB.equals(type))) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(field);
    }

    public void writeLOB(DatabaseField field, Object value, ResultSet resultSet, AbstractSession session) throws SQLException {
        if (this.isBlob(field.getType())) {
            BLOB blob = (BLOB)resultSet.getObject(field.getName());
            blob.putBytes(1L, (byte[])value);
            session.log(1, "sql", "write_BLOB", (Object)blob.length(), (Object)field.getName());
        } else if (this.isClob(field.getType())) {
            CLOB clob = (CLOB)resultSet.getObject(field.getName());
            clob.putString(1L, (String)value);
            session.log(1, "sql", "write_CLOB", (Object)clob.length(), (Object)field.getName());
        }
    }

    protected boolean isBlob(Class type) {
        return ClassConstants.BLOB.equals(type);
    }

    protected boolean isClob(Class type) {
        return ClassConstants.CLOB.equals(type);
    }

    public boolean isNativeConnectionRequiredForLobLocator() {
        return true;
    }

    public void setShouldUseLocatorForLOBWrite(boolean usesLocatorForLOBWrite) {
        this.usesLocatorForLOBWrite = usesLocatorForLOBWrite;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int lobValueLimits) {
        this.lobValueLimits = lobValueLimits;
    }

    public Array createArray(String elementDataTypeName, Object[] elements, Connection connection) throws SQLException {
        return new ARRAY(new ArrayDescriptor(elementDataTypeName, connection), connection, (Object)elements);
    }

    public Struct createStruct(String structTypeName, Object[] attributes, Connection connection) throws SQLException {
        return new STRUCT(new StructDescriptor(structTypeName, connection), connection, attributes);
    }

    public Object getRefValue(Ref ref, Connection connection) throws SQLException {
        ((REF)ref).setPhysicalConnectionOf(connection);
        return ((REF)ref).getValue();
    }

    public void freeTemporaryObject(Object value) throws SQLException {
        if (value instanceof CLOB && ((CLOB)value).isTemporary()) {
            ((CLOB)value).freeTemporary();
        } else if (value instanceof BLOB && ((BLOB)value).isTemporary()) {
            ((BLOB)value).freeTemporary();
        }
    }
}

