/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarCharType;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProcedureDDLTestSuite {
    static final String SIMPLEPROC = "DTB_SIMPLEPROC";
    static final String CREATE_SIMPLEPROC = "CREATE PROCEDURE DTB_SIMPLEPROC(X IN VARCHAR) AS\nBEGIN\nnull;\nEND;";
    static final String DROP_SIMPLEPROC = "DROP PROCEDURE DTB_SIMPLEPROC";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static ProcedureType procedureType = null;
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws SQLException, ClassNotFoundException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_SIMPLEPROC, ddlDebug);
        }
        boolean worked = true;
        String msg = null;
        try {
            String schema = System.getProperty("db.user", "scott");
            procedureType = dtBuilder.buildProcedures(conn, schema, SIMPLEPROC).get(0);
        }
        catch (Exception e) {
            worked = false;
            msg = e.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_SIMPLEPROC, ddlDebug);
        }
    }

    @Test
    public void testProcedureName() {
        Assert.assertEquals((String)"incorrect procedure name", (Object)SIMPLEPROC, (Object)procedureType.getProcedureName());
    }

    @Test
    public void testNumberOfArgs() {
        List<ArgumentType> args = procedureType.getArguments();
        Assert.assertTrue((String)"incorrect number of arguments", (args.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testArgumentNames() {
        List<ArgumentType> args = procedureType.getArguments();
        ArgumentType argFirst = args.get(0);
        Assert.assertEquals((String)"incorrect argument name", (Object)"X", (Object)argFirst.getArgumentName());
    }

    @Test
    public void testArgumentTypes() {
        List<ArgumentType> args = procedureType.getArguments();
        ArgumentType argFirst = args.get(0);
        Assert.assertEquals((String)("incorrect type for args  " + argFirst.getArgumentName()), (Object)new VarCharType().getTypeName(), (Object)argFirst.getEnclosedType().getTypeName());
    }
}

