/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.SizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.URowIdType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IOTTableDDLTestSuite {
    static final String IOTTABLE = "DTB_IOTTABLE";
    static final String IOTTABLE_FIELD1 = "ID";
    static final String IOTTABLE_FIELD2 = "NAME";
    static final String IOTTABLE_FIELD3 = "RID";
    static final String CREATE_IOTTABLE = "CREATE TABLE DTB_IOTTABLE (\nID NUMBER(4,0) NOT NULL ENABLE,\nNAME VARCHAR2(25),\nRID UROWID(4000),\nPRIMARY KEY (ID,NAME)\n) ORGANIZATION INDEX NOCOMPRESS OVERFLOW";
    static final String DROP_IOTTABLE = "DROP TABLE DTB_IOTTABLE";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static TableType tableType = null;
    static List<String> expectedFieldNames = new ArrayList<String>();
    static List<String> expectedPKFieldNames = new ArrayList<String>();
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws SQLException, ClassNotFoundException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_IOTTABLE, ddlDebug);
        }
        boolean worked = true;
        String msg = null;
        try {
            tableType = dtBuilder.buildTables(conn, "", IOTTABLE).get(0);
        }
        catch (Exception e) {
            worked = false;
            msg = e.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
        expectedPKFieldNames.add(IOTTABLE_FIELD1);
        expectedPKFieldNames.add(IOTTABLE_FIELD2);
        expectedFieldNames.add(IOTTABLE_FIELD1);
        expectedFieldNames.add(IOTTABLE_FIELD2);
        expectedFieldNames.add(IOTTABLE_FIELD3);
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_IOTTABLE, ddlDebug);
        }
    }

    @Test
    public void testTableName() {
        Assert.assertEquals((String)"incorrect table name", (Object)IOTTABLE, (Object)tableType.getTableName());
    }

    @Test
    public void testNumberOfColumns() {
        List<FieldType> columns = tableType.getColumns();
        Assert.assertTrue((String)"incorrect number of columns", (columns.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testPrimaryKeys() {
        List<FieldType> columns = tableType.getColumns();
        ArrayList<String> pkFieldNames = new ArrayList<String>();
        for (FieldType field : columns) {
            if (!field.pk()) continue;
            pkFieldNames.add(field.getFieldName());
        }
        Assert.assertEquals((String)"incorrect PK column names", expectedPKFieldNames, pkFieldNames);
    }

    @Test
    public void testColumnNames() {
        List<FieldType> columns = tableType.getColumns();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldType field : columns) {
            fieldNames.add(field.getFieldName());
        }
        Assert.assertEquals((String)"incorrect column names", expectedFieldNames, fieldNames);
    }

    @Test
    public void testColumnTypes() {
        List<FieldType> columns = tableType.getColumns();
        FieldType field1 = columns.get(0);
        DatabaseType col1Type = field1.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [ID]", (Object)new NumericType().getTypeName(), (Object)col1Type.getTypeName());
        Assert.assertTrue((String)"incorrect NULL constraint for column [ID]", (boolean)field1.notNull());
        FieldType field2 = columns.get(1);
        DatabaseType col2Type = field2.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [NAME]", (Object)new VarChar2Type().getTypeName(), (Object)col2Type.getTypeName());
        Assert.assertFalse((String)"incorrect NULL constraint for column [NAME]", (boolean)field2.notNull());
        Assert.assertTrue((String)"incorrect size for column [NAME]", (((SizedType)col2Type).getSize() == 25L ? 1 : 0) != 0);
        FieldType field3 = columns.get(2);
        DatabaseType col3Type = field3.getEnclosedType();
        Assert.assertEquals((String)"incorrect type for column [RID]", (Object)new URowIdType().getTypeName(), (Object)col3Type.getTypeName());
        Assert.assertFalse((String)"incorrect NULL constraint for column [RID]", (boolean)field3.notNull());
    }
}

