/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.visit;

import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.DoubleType;
import org.eclipse.persistence.tools.oracleddl.metadata.FloatType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.PrecisionType;
import org.eclipse.persistence.tools.oracleddl.metadata.RealType;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.BaseDatabaseTypeVisitor;

class PrecisionTypeVisitor
extends BaseDatabaseTypeVisitor {
    protected String typeName;
    protected long precision;
    protected long defaultPrecision;
    protected long scale;

    PrecisionTypeVisitor() {
    }

    public void visit(PrecisionType databaseType) {
        this.typeName = databaseType.getTypeName();
        this.precision = databaseType.getPrecision();
        this.defaultPrecision = databaseType.getDefaultPrecision();
        this.scale = databaseType.getScale();
    }

    @Override
    public void visit(DecimalType databaseType) {
        this.visit((PrecisionType)databaseType);
    }

    @Override
    public void visit(DoubleType databaseType) {
        this.visit((PrecisionType)databaseType);
    }

    @Override
    public void visit(FloatType databaseType) {
        this.visit((PrecisionType)databaseType);
    }

    @Override
    public void visit(NumericType databaseType) {
        this.visit((PrecisionType)databaseType);
    }

    @Override
    public void visit(RealType databaseType) {
        this.visit((PrecisionType)databaseType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.typeName);
        if (this.precision != this.defaultPrecision) {
            sb.append('(');
            sb.append(this.precision);
            if (this.scale != 0L) {
                sb.append(',');
                sb.append(this.scale);
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

